local cockpit = folder .. "../../../Cockpit/"
local f4einput = folder .. "../../../Input/"
dofile(cockpit .. "devices.lua")
dofile(cockpit .. "command_defs.lua")
dofile(f4einput .. "utils.lua")
dofile(f4einput .. "bind_dsl.lua")
dofile(f4einput .. "bind_categories.lua")

local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")
res.axisCommands = {}

local binds = {
    --*************** EXTENDED COMMANDS *****************
    push_button('*Pave Spike Reject Override Button', device_commands.WSO_TGT_DESIGNATOR_REJECT_OVERRIDE_BUTTON, device_commands.WSO_TGT_DESIGNATOR_REJECT_OVERRIDE_BUTTON_AXIS, bind_templates.target_designator_set_control()),

    switch_3('*Antenna Stabilization Mode', { 'Drift Out', 'Nor', 'Stab Out' }, nil, device_commands.RADAR_WSO_STAB_SWITCH, device_commands.RADAR_WSO_STAB_SWITCH_INC_DEC, device_commands.RADAR_WSO_STAB_SWITCH_NEXT, device_commands.RADAR_WSO_STAB_SWITCH_AXIS, bind_templates.radar_antenna_panel(), { binds = {
        dec = { value_down = -0.5 },
        inc = { value_down = 0.5 },
    } }),

    --*************** Temporary *********************************************************************

    --switch_2('Video', { 'Close', 'Open' }, device_commands.PILOT_VIDEO_SWITCH, device_commands.PILOT_VIDEO_TOGGLE, nil, { cockpit_device_id = devices.VIDEO, category = { categories.temp } }, { binds = { pos_2_way = { remove = true } } }), -- TODO Find better place

    --*************** WSO Binds (until Jester is better) *********************************************************************
    { name = _('[WSO] Antenna Hand Control Slew - Right'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = 0.5, value_up = 0.0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Left'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = -0.5, value_up = 0.0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Up'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = -0.5, value_up = 0.0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Down'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = 0.5, value_up = 0.0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Right (fast)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = 1, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Left (fast)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = -1, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Up (fast)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = -1, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Down (fast)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = 1, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Right (slow)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = 0.25, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Left (slow)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, value_down = -0.25, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Up (slow)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = -0.25, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew - Down (slow)'), down = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, up = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, value_down = 0.25, value_up = 0, cockpit_device_id = devices.RADAR, category = categories.wso_temp },

    switch_3_springloaded_both('[WSO] Antenna Elevation', { 'Down', 'Stop', 'Up' }, nil, device_commands.RADAR_ANTENNA_HAND_CONTROL_ELEVATION, device_commands.RADAR_ANTENNA_HAND_CONTROL_ELEVATION_INC_DEC, device_commands.RADAR_ANTENNA_HAND_CONTROL_ELEVATION_AXIS, bind_templates.antenna_stick(), { category = categories.wso_temp }),
    push_button('[WSO] Antenna Hand Control Challenge Button', device_commands.RADAR_ANTENNA_HAND_CONTROL_CHALLENGE, nil, bind_templates.antenna_stick(), { category = categories.wso_temp }),
    trigger_2('[WSO] Antenna Hand Control Trigger', nil, device_commands.RADAR_ANTENNA_HAND_CONTROL_TRIGGER, device_commands.RADAR_ANTENNA_HAND_CONTROL_TRIGGER_SEQUENCE, device_commands.RADAR_ANTENNA_HAND_CONTROL_TRIGGER_AXIS, bind_templates.antenna_stick(), { category = categories.wso_temp }),

    knob_inc_dec('[WSO] Radar Receiver Gain (fine)', nil, 0.01, device_commands.RADAR_Rcvr_Gain_Fine_INC_DEC, device_commands.RADAR_Rcvr_Gain_Fine_AXIS, bind_templates.radar_panel(), { category = categories.wso_temp }),
    knob_inc_dec('[WSO] Radar Receiver Gain (coarse)', nil, 0.01, device_commands.RADAR_Rcvr_Gain_Coarse_INC_DEC, device_commands.RADAR_Rcvr_Gain_Coarse_AXIS, bind_templates.radar_panel(), { category = categories.wso_temp }),

    push_button('[WSO] Freeze Button', device_commands.CURSOR_CTRL_PANEL_WSO_FREEZE_BUTTON, device_commands.CURSOR_CTRL_PANEL_WSO_FREEZE_BUTTON_AXIS, bind_templates.cursor_control_panel(), { category = categories.wso_temp }),
    push_button('[WSO] Insert Target Button', device_commands.CURSOR_CTRL_PANEL_WSO_TGT_INSERT_BUTTON, device_commands.CURSOR_CTRL_PANEL_WSO_TGT_INSERT_BUTTON_AXIS, bind_templates.cursor_control_panel(), { category = categories.wso_temp }),
    push_button('[WSO] Reset Target Button', device_commands.CURSOR_CTRL_PANEL_WSO_RESET_BUTTON, device_commands.CURSOR_CTRL_PANEL_WSO_RESET_BUTTON_AXIS, bind_templates.cursor_control_panel(), { category = categories.wso_temp }),

    --******************* Flight Controls *****************************************************************
    { name = _('Aircraft Pitch Down'), combos = combo('Up'), pressed = iCommandPlaneUpStart, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Aircraft Pitch Up'), combos = combo('Down'), pressed = iCommandPlaneDownStart, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Aircraft Bank Left'), combos = combo('Left'), down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Aircraft Bank Right'), combos = combo('Right'), down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Aircraft Rudder Left'), combos = combo('Z'), down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, category = { categories.flight_controls, categories.pedals } },
    { name = _('Aircraft Rudder Right'), combos = combo('X'), down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, category = { categories.flight_controls, categories.pedals } },

    { name = _('Throttle Up'), combos = combo('Num+'), pressed = iCommandThrottleIncrease, up = iCommandThrottle1Stop, category = { categories.flight_controls, categories.throttle, categories.essentials } },
    { name = _('Throttle Down'), combos = combo('Num-'), pressed = iCommandThrottleDecrease, up = iCommandThrottle1Stop, category = { categories.flight_controls, categories.throttle, categories.essentials } },

    { name = _('Occupy Pilot Seat'), combos = combo('1'), down = device_commands.COCKPIT_CHANGE_SEATS, value_down = 1, cockpit_device_id = devices.COCKPITMECHANICS, category = categories.view_cockpit },
    { name = _('Occupy WSO Seat'), combos = combo('2'), down = device_commands.COCKPIT_CHANGE_SEATS, value_down = 2, cockpit_device_id = devices.COCKPITMECHANICS, category = categories.view_cockpit },

    push_button('Toggle Multicrew Controls Input', device_commands.PILOT_LOCAL_INPUT_TOGGLE, nil, { cockpit_device_id = devices.INPUTCONTROLS, category = { categories.flight_controls } }, { binds = { push = { combos = combo('C', 'LShift') } } }),

    { combos = { { key = 'M', reformers = { 'LShift' } } }, down = iCommandToggleMirrors, name = _('Mirrors - [Toggle]'), category = _('View Cockpit'), features = { "Mirrors" } },

    --******************* Engine Panel *********************************************************************
    switch_2('UHF Antenna', { 'Lower', 'Upper' }, device_commands.ANTENNA_SELECTION_SWITCH, device_commands.ANTENNA_SELECTION_SWITCH_TOGGLE, device_commands.ANTENNA_SELECTION_SWITCH_AXIS, bind_templates.uhf_panel_pilot(), { category = { categories.radio, categories.left_console } }),

    switch_2('Left Engine Idle Detent', { 'On', 'Off' }, device_commands.ENGINES_IdleStopLeft_POS, device_commands.ENGINES_IdleStopLeft_TOGGLE, nil, bind_templates.engine_throttle(), { binds = {
        toggle = { combos = combo('End', 'RAlt') },
    } }),
    switch_2('Right Engine Idle Detent', { 'On', 'Off' }, device_commands.ENGINES_IdleStopRight_POS, device_commands.ENGINES_IdleStopRight_TOGGLE, nil, bind_templates.engine_throttle(), { binds = {
        toggle = { combos = combo('End', 'RCtrl') },
    } }),

    switch_3_springloaded_up('CADC Corrections', { 'Off', 'Normal', 'Reset' }, nil, device_commands.SPC_switch, device_commands.SPC_switch_INC_DEC, device_commands.SPC_switch_NEXT, device_commands.SPC_switch_AXIS, { cockpit_device_id = devices.CADC, category = { categories.navigation_computer, categories.left_console } }),
    switch_3_springloaded_both('Start Engine Switch', { 'Left', 'None', 'Right' }, { '[Left]', '[Right]' }, device_commands.ENGINES_StartSwitch, nil, nil, bind_templates.engine_panel()), -- TODO Missing INC/DEC (frontend is manual)
    switch_2('Left Engine Master Switch', nil, device_commands.ENGINES_LeftMasterSwitch, device_commands.ENGINES_LeftMasterSwitch_TOGGLE, device_commands.ENGINES_LeftMasterSwitch_AXIS, bind_templates.engine_panel()),
    switch_2('Right Engine Master Switch', nil, device_commands.ENGINES_RightMasterSwitch, device_commands.ENGINES_RightMasterSwitch_TOGGLE, device_commands.ENGINES_RightMasterSwitch_AXIS, bind_templates.engine_panel()),

    --******************* Canopy & Ejection *****************************************************************
    switch_2('Canopy Handle', { 'Close', 'Open' }, device_commands.CANOPYCONTROLS_ActuatePilotCanopy, device_commands.CANOPYCONTROLS_ActuatePilotCanopy_TOGGLE, device_commands.CANOPYCONTROLS_ActuatePilotCanopy_AXIS, bind_templates.canopy(), { binds = { toggle = { combos = combo('C', 'LCtrl') } } }),
    switch_2('Canopy Emergency Handle', { 'Safe', 'Jettison' }, device_commands.CANOPYCONTROLS_JettisonPilotCanopy, device_commands.CANOPYCONTROLS_JettisonPilotCanopy_TOGGLE, device_commands.CANOPYCONTROLS_JettisonPilotCanopy_AXIS, bind_templates.canopy()),
  
    push_button('Eject (3 times)', device_commands.PILOT_EJECT_3_TIMES, nil, bind_templates.ejection(), { binds = { push = { combos = combo('E', 'LCtrl') } } }),
    push_button('Eject (instant)', device_commands.PILOT_EJECT_INSTANT, nil, bind_templates.ejection(), { binds = { push = { combos = combo('E', 'RCtrl') } } }),

    switch_2('Signal Ejection To WSO Button', { 'Safe', 'Ejection' }, device_commands.PILOT_EJECT_LIGHT_PUSH, device_commands.PILOT_EJECT_LIGHT_PUSH_TOGGLE, device_commands.PILOT_EJECT_LIGHT_PUSH_AXIS, { cockpit_device_id = devices.EJECTION_SEAT_SYSTEM, category = { categories.general, categories.left_wall } }),

    --*************** ADI *********************************************************************
    knob_inc_dec('Adjust Pitch', { '[Down]', '[Up]' }, 0.01, device_commands.MAINADI_pitchtrim_keyboard, device_commands.MAINADI_pitchtrim_AXIS, bind_templates.adi_pilot()),
    switch_2('Reference System Selector Switch', { 'Primary', 'Standby' }, device_commands.MAINADI_reference_absolute, device_commands.MAINADI_reference_toggle, device_commands.MAINADI_reference_AXIS, bind_templates.adi_pilot()),

    push_button('Marker-Beacon Lamp Test Button', device_commands.PILOT_MARKER_BEACON_LIGHT_PRESS, device_commands.PILOT_MARKER_BEACON_LIGHT_PRESS_AXIS, { cockpit_device_id = devices.VOR_ILS, category = { categories.vor_ils, categories.navigation, categories.main_panel } }),
    knob_inc_dec('Marker-Beacon Lamp Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_MARKER_BEACON_LIGHT_ROTATION_INC_DEC, device_commands.PILOT_MARKER_BEACON_LIGHT_ROTATION_AXIS, { cockpit_device_id = devices.VOR_ILS, category = { categories.vor_ils, categories.navigation, categories.main_panel } }),

    --******************* AFCS *********************************************************************
    switch_2('STAB AUG Yaw', { 'Disengage', 'Engage' }, device_commands.AFCS_ENGAGE_STAB_AUG_YAW, device_commands.AFCS_ENGAGE_STAB_AUG_YAW_TOGGLE, device_commands.AFCS_ENGAGE_STAB_AUG_YAW_AXIS, bind_templates.afcs()),
    switch_2('STAB AUG Roll', { 'Disengage', 'Engage' }, device_commands.AFCS_ENGAGE_STAB_AUG_ROLL, device_commands.AFCS_ENGAGE_STAB_AUG_ROLL_TOGGLE, device_commands.AFCS_ENGAGE_STAB_AUG_ROLL_AXIS, bind_templates.afcs()),
    switch_2('STAB AUG Pitch', { 'Disengage', 'Engage' }, device_commands.AFCS_ENGAGE_STAB_AUG_PITCH, device_commands.AFCS_ENGAGE_STAB_AUG_PITCH_TOGGLE, device_commands.AFCS_ENGAGE_STAB_AUG_PITCH_AXIS, bind_templates.afcs()),

    switch_2('AFCS Autopilot', { 'Disengage', 'Engage' }, device_commands.AFCS_ENGAGE_AFCS, device_commands.AFCS_ENGAGE_AFCS_TOGGLE, device_commands.AFCS_ENGAGE_AFCS_AXIS, bind_templates.afcs(), { binds = { toggle = { combos = combo('A', 'LAlt') } } }),
    switch_2('ALT Hold', { 'Disengage', 'Engage' }, device_commands.AFCS_ENGAGE_ALT, device_commands.AFCS_ENGAGE_ALT_TOGGLE, device_commands.AFCS_ENGAGE_ALT_AXIS, bind_templates.afcs()),

    --******************* Control Surfaces *****************************************************************
    switch_3('Flaps/Slats Switch', { 'Norm', 'Out', 'Out&Down' }, { '[Step Up]', '[Step Down]' }, device_commands.CONTROLSURFACES_FlapsSlatsSwitch, device_commands.CONTROLSURFACES_FlapsSlatsSwitchStep, device_commands.CONTROLSURFACES_FlapsSlatsSwitchToggle, device_commands.CONTROLSURFACES_FlapsSlatsSwitch_AXIS, bind_templates.flaps(), { binds = {
        inc = { combos = combo('F') },
        dec = { combos = combo('F', 'LShift') },
    } }),

    switch_2('Flaps/Slats Emergency Extension Handle', nil, device_commands.CONTROLSURFACES_PilotEmergencyFlapsSlats, device_commands.CONTROLSURFACES_PilotEmergencyFlapsSlats_TOGGLE, device_commands.CONTROLSURFACES_PilotEmergencyFlapsSlats_AXIS, bind_templates.flaps()),

    switch_2('Slats Override Switch Cover', { 'Close', 'Open' }, device_commands.PILOT_SLATS_OVERRIDE_COVER, device_commands.PILOT_SLATS_OVERRIDE_COVER_TOGGLE, device_commands.PILOT_SLATS_OVERRIDE_COVER_AXIS, bind_templates.flaps()),
    switch_2('Slats Override Switch', { 'Norm', 'In' }, device_commands.PILOT_SLATS_OVERRIDE_SWITCH, device_commands.PILOT_SLATS_OVERRIDE_SWITCH_TOGGLE, device_commands.PILOT_SLATS_OVERRIDE_SWITCH_AXIS, bind_templates.flaps()),

    --******************* Weapons Selection Panel *****************************************************************
    knob_inc_dec('Flight Instrument Brightness', nil, 0.01, device_commands.PILOT_FLT_INST_KNOB_INC_DEC, device_commands.PILOT_FLT_INST_KNOB_AXIS, { cockpit_device_id = devices.INTERIOR_LIGHTS, category = { categories.lights, categories.main_panel, categories.weapons_selection_panel } }),
    knob_full_circle('Fuze Arming', { 'Safe', 'Nose', 'Nose & Tail', 'Tail' }, nil, device_commands.WEAPONS_Arm_Switch, device_commands.WEAPONS_Arm_Switch_INC_DEC, device_commands.WEAPONS_Arm_Switch_AXIS, bind_templates.weapons_selection_panel()),

    knob_inc_dec('Weapon Selection Panel Buttons Light Brightness', nil, 0.01, device_commands.PILOT_STATION_SELECT_DIM_KNOB_INC_DEC, device_commands.PILOT_STATION_SELECT_DIM_KNOB_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Gun Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_Gun_Arm, device_commands.WEAPONS_Gun_Arm_TOGGLE, device_commands.WEAPONS_Gun_Arm_AXIS, bind_templates.weapons_selection_panel()),

    switch_2('Left-Outer Station Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_LO_Arm, device_commands.WEAPONS_LO_Arm_TOGGLE, device_commands.WEAPONS_LO_Arm_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Left-Inner Station Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_LI_Arm, device_commands.WEAPONS_LI_Arm_TOGGLE, device_commands.WEAPONS_LI_Arm_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Center Station Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_CTR_Arm, device_commands.WEAPONS_CTR_Arm_TOGGLE, device_commands.WEAPONS_CTR_Arm_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Right-Inner Station Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_RI_Arm, device_commands.WEAPONS_RI_Arm_TOGGLE, device_commands.WEAPONS_RI_Arm_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Right-Outer Station Status', { 'Safe', 'Arm' }, device_commands.WEAPONS_RO_Arm, device_commands.WEAPONS_RO_Arm_TOGGLE, device_commands.WEAPONS_RO_Arm_AXIS, bind_templates.weapons_selection_panel()),

    switch_2('Master Arm', { 'Safe', 'Arm' }, device_commands.WEAPONS_Master_Arm, device_commands.WEAPONS_Master_Arm_TOGGLE, device_commands.WEAPONS_Master_Arm_AXIS, bind_templates.weapons_selection_panel()),

    knob('Delivery Mode', { 'Toss', 'Loft', 'O/S', 'T/LAD', 'TL', 'Off', 'Direct', 'Target Find', 'DT', 'DL', 'L', 'Offset', 'AGM-45' }, nil, device_commands.WEAPONS_SelectDeliveryMode, device_commands.WEAPONS_SelectDeliveryMode_INC_DEC, device_commands.WEAPONS_SelectDeliveryMode_NEXT, device_commands.WEAPONS_SelectDeliveryMode_AXIS, bind_templates.weapons_selection_panel()),
    knob('Weapon Selector', { 'Rocket & Dispenser', 'Arm', 'TV', 'C', 'B', 'A', 'AGM-12', 'Bombs' }, nil, device_commands.WEAPONS_SelectWeapon, device_commands.WEAPONS_SelectWeapon_INC_DEC, nil, device_commands.WEAPONS_SelectWeapon_AXIS, bind_templates.weapons_selection_panel()),
    switch_3('Radar-Missile CW', { 'Off', 'Standby', 'On' }, nil, device_commands.WEAPONS_CW_Switch, device_commands.WEAPONS_CW_Switch_INC_DEC,  device_commands.WEAPONS_CW_Switch_NEXT, device_commands.WEAPONS_CW_Switch_AXIS, bind_templates.weapons_selection_panel(), { binds = {
        dec = { value_down = -0.5 },
        inc = { value_down = 0.5 },
    } }),
    switch_2('Interlock Position', { 'Out', 'In' }, device_commands.WEAPONS_Interlock_Switch, device_commands.WEAPONS_Interlock_Switch_TOGGLE, device_commands.WEAPONS_Interlock_Switch_AXIS, bind_templates.weapons_selection_panel()),

    knob_inc_dec_variants('Interval (s)', nil, 0.01, 0.005, 0.02, device_commands.WEAPONS_SelectBombInterval_INC_DEC, device_commands.WEAPONS_SelectBombInterval_INC_DEC_ACCELERATING, device_commands.WEAPONS_SelectBombInterval_AXIS, bind_templates.weapons_selection_panel()),
    switch_2('Interval Multiplier', { 'Normal', 'x10' }, device_commands.WEAPONS_BombIntervalSwitch, device_commands.WEAPONS_BombIntervalSwitch_TOGGLE, device_commands.WEAPONS_BombIntervalSwitch_AXIS, bind_templates.weapons_selection_panel()),
    knob('Quantity', { 'P', 'S', 'C', '18', '12', '9', '6', '5', '4', '3', '2', '1' }, nil, device_commands.WEAPONS_SelectBombQty, device_commands.WEAPONS_SelectBombQty_INC_DEC, nil, device_commands.WEAPONS_SelectBombQty_AXIS, bind_templates.weapons_selection_panel()),

    knob_full_circle('Jettison Selector', { 'Off', 'Right Forward', 'Right Wing', 'Right Aft', 'Stores', 'Left Aft', 'Left Wing', 'Left Forward' }, nil, device_commands.WEAPONS_Jettison_Selection_Knob, device_commands.WEAPONS_Jettison_Selection_Knob_INC_DEC, device_commands.WEAPONS_Jettison_Selection_Knob_AXIS, bind_templates.weapons_selection_panel()),
    push_button('Jettison Button', device_commands.WEAPONS_Jettison_Button, device_commands.WEAPONS_Jettison_Button_AXIS, bind_templates.weapons_selection_panel()),

    --******************* Stick *****************************************************************
    switch_2('Stick Visibility', { 'Show', 'Hide' }, device_commands.PILOT_HIDE_SHOW_STICK, device_commands.PILOT_HIDE_SHOW_STICK_TOGGLE, device_commands.PILOT_HIDE_SHOW_STICK_AXIS, { cockpit_device_id = devices.PILOT_FRONT_PANEL, category = { categories.stick } }),

    trigger_2('Trigger', nil, device_commands.WEAPONS_Trigger, device_commands.WEAPONS_Trigger_SEQUENCE, device_commands.WEAPONS_Trigger_AXIS, bind_templates.weapon_controls_stick(), { category = { categories.stick, categories.weapons, categories.essentials }, binds = { seq_0_half_1 = { combos = combo('Space') } } }),
    push_button('Bomb Release Button', device_commands.WEAPONS_BombButton, device_commands.WEAPONS_BombButton_AXIS, bind_templates.weapon_controls_stick(), { category = { categories.stick, categories.weapons, categories.essentials }, binds = { push = { combos = combo('Space', 'RAlt') } } }),
    push_button('Air Refueling (AAR) Release Button', device_commands.WEAPONS_ARR, device_commands.WEAPONS_ARR_AXIS, bind_templates.weapon_controls_stick(), { binds = { push = { combos = combo('S') } } }),
    push_button('Nose Gear Steering / Auto Acquisition Button', device_commands.LANDING_GEAR_PILOT_ENGAGE_NOSEWHEEL_STEERING, device_commands.LANDING_GEAR_PILOT_ENGAGE_NOSEWHEEL_STEERING_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.radar_controls, categories.stick, categories.essentials } }, { binds = { push = { combos = combo('N') } } }),
    push_button('Emergency Quick Release Lever', device_commands.PILOT_EMERGENCY_QUICK_RELEASE_LEVER, device_commands.PILOT_EMERGENCY_QUICK_RELEASE_LEVER_AXIS, { cockpit_device_id = devices.INPUTCONTROLS, category = { categories.stick } }),

    { name = _('Trim - Nose Up (Hat Aft)'), up = iCommandPlaneTrimPitch, pressed = iCommandPlaneTrimPitch, value_up = 0, value_pressed = 1, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Trim - Nose Down (Hat Forward)'), up = iCommandPlaneTrimPitch, pressed = iCommandPlaneTrimPitch, value_up = 0, value_pressed = -1, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Trim - Left Wing Down (Hat Left)'), up = iCommandPlaneTrimRoll, pressed = iCommandPlaneTrimRoll, value_up = 0, value_pressed = -1, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Trim - Right Wing Down (Hat Right)'), up = iCommandPlaneTrimRoll, pressed = iCommandPlaneTrimRoll, value_up = 0, value_pressed = 1, category = { categories.flight_controls, categories.stick, categories.essentials } },
    { name = _('Trim - Rudder Left'), up = iCommandPlaneTrimRudder, pressed = iCommandPlaneTrimRudder, value_up = 0, value_pressed = -1, category = { categories.flight_controls, categories.left_console, categories.essentials } },
    { name = _('Trim - Rudder Right'), up = iCommandPlaneTrimRudder, pressed = iCommandPlaneTrimRudder, value_up = 0, value_pressed = 1, category = { categories.flight_controls, categories.left_console, categories.essentials } },

    --******************* Throttle *****************************************************************
    push_button('Left Engine Ignition', device_commands.ENGINES_LeftIgnition, device_commands.ENGINES_LeftIgnition_AXIS, bind_templates.engine_throttle(), { category = { categories.engines, categories.throttle, categories.essentials }, binds = { push = { combos = combo('Home', 'RAlt') } } }),
    push_button('Right Engine Ignition', device_commands.ENGINES_RightIgnition, device_commands.ENGINES_RightIgnition_AXIS, bind_templates.engine_throttle(), { category = { categories.engines, categories.throttle, categories.essentials }, binds = { push = { combos = combo('Home', 'RCtrl') } } }),

    push_button('Cage Button', device_commands.WEAPONS_Cage, device_commands.WEAPONS_Cage_AXIS, bind_templates.weapon_controls_throttle(), { category = { categories.throttle, categories.weapons, categories.essentials }, binds = { push = { combos = combo('C') } } }),
    push_button('Dispense Countermeasures (Chaff/Flare)', device_commands.PILOT_COUNTERMEASURES_DISPENSE, device_commands.PILOT_COUNTERMEASURES_DISPENSE_AXIS, { cockpit_device_id = devices.COUNTERMEASURES, category = { categories.cms, categories.throttle, categories.essentials } }),

    -- Pilot Speed Brake Switch: maintaining IN, maintaining STOP, and momentary OUT
    switch_3_springloaded_down('Speed Brake', { 'Out', 'Stop', 'In' }, { '[Aft]', '[Forward]' }, device_commands.CONTROLSURFACES_BrakeExtendRetract, device_commands.CONTROLSURFACES_BrakeStep, device_commands.CONTROLSURFACES_BrakeToggle, device_commands.CONTROLSURFACES_Brake_AXIS, bind_templates.speedbrake(), { binds = {
        pos_neg_1 = { combos = combo('B', 'LCtrl') },
        pos_0 = { combos = combo('B', { 'RAlt' }) },
        pos_1 = { combos = combo('B', 'LShift') },
        next = { combos = combo('B') },
    } }),


    switch_3('Gun/Missile Pinky Switch', { 'Gun', 'Heat', 'Radar' }, { '[Left]', '[Right]' }, device_commands.WEAPONS_Gun_Missile_Switch, device_commands.WEAPONS_Gun_Missile_Switch_INC_DEC, device_commands.PILOT_L_GEN_SWITCH_NEXT, device_commands.WEAPONS_Gun_Missile_Switch_AXIS, bind_templates.weapon_controls_throttle(), {
        category = { categories.throttle, categories.weapons, categories.essentials },
        binds = {
            pos_neg_1 = { combos = combo('W', 'LShift') },
            pos_0 = { combos = combo('S', 'LShift') },
            pos_1 = { combos = combo('D', 'LShift') },
        } }),
    push_button('Gun/Missile Pinky Switch - Reject', device_commands.WEAPONS_Heat_Reject, device_commands.WEAPONS_Heat_Reject_AXIS, bind_templates.weapon_controls_throttle(), {
        category = { categories.throttle, categories.weapons, categories.essentials },
        binds = {
            push = { combos = combo('X', 'LShift') }
        } }),

    --push_button('Cycle A2A Weapon', device_commands.WEAPONS_Cycle_Selected, device_commands.WEAPONS_Cycle_Selected_AXIS, bind_templates.weapon_controls_throttle(), { binds = { push = { combos = combo('J', 'LShift') } } }),
    --push_button('Cycle Maverick On Current Station', device_commands.WEAPONS_Maverick_Reject, device_commands.WEAPONS_Maverick_Reject_AXIS, bind_templates.weapon_controls_throttle(), { binds = { push = { combos = combo('J', 'LAlt') } } }),

    switch_3_springloaded_both('Microphone Switch', { 'ICS', 'Off', 'UHF' }, { '[Aft]', '[Forward]' }, device_commands.PILOT_THROTTLE_MIC_SWITCH, nil, device_commands.PILOT_THROTTLE_MIC_SWITCH_AXIS, { cockpit_device_id = devices.ICS, category = { categories.throttle, categories.ics, categories.essentials }}, { binds = {
        pos_neg_1 = { combos = combo('\\', 'RAlt') },
        pos_1 = { combos = combo('\\', 'RShift') },
    }}),
    switch_3_springloaded_both('Microphone Switch - SRS/VOIP only', { 'ICS', 'Off', 'UHF' }, { '[Aft]', '[Forward]' }, device_commands.PILOT_THROTTLE_MIC_SWITCH_EXPORT_ONLY, nil, device_commands.PILOT_THROTTLE_MIC_SWITCH_EXPORT_ONLY_AXIS, { cockpit_device_id = devices.ICS, category = { categories.throttle, categories.ics, categories.essentials } }),

    --**************** Landing Gear & Anti-Skid & Hook ************************************************************
    switch_2('Landing Gear', { 'Up', 'Down' }, device_commands.LANDING_GEAR_PilotHandle, device_commands.LANDING_GEAR_Pilot_Toggle, device_commands.LANDING_GEAR_Pilot_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.main_panel } }, { binds = {
        pos_0 = { combos = combo('G', 'LShift') },
        pos_1 = { combos = combo('G', 'LCtrl') },
        toggle = { combos = combo('G') },
    } }),
    switch_2('Landing Gear - Emergency Extension', nil, device_commands.PILOT_EMERGENCY_LANDING_GEAR, device_commands.PILOT_EMERGENCY_LANDING_GEAR_TOGGLE, device_commands.PILOT_EMERGENCY_LANDING_GEAR_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.main_panel } }),
    switch_2('Anti-Skid', nil, device_commands.LANDING_GEAR_AntiSkid, device_commands.LANDING_GEAR_AntiSkid_TOGGLE, device_commands.LANDING_GEAR_AntiSkid_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.left_console } }),

    switch_2('Arresting Hook Control Handle', { 'In', 'Out' }, device_commands.PILOT_HOOK_HANDLE, device_commands.PILOT_HOOK_HANDLE_TOGGLE, device_commands.PILOT_HOOK_HANDLE_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.right_sub_panel } }),

    --*************** Brakes *********************************************************************
    { name = _('Wheel Brake (Both)'), combos = combo('D'), pressed = iCommandWheelBrake, up = iCommandWheelBrake, value_pressed = -1, value_up = 1, category = { categories.gears_brakes_hook, categories.pedals } },
    { name = _('Wheel Brake (Left)'), combos = combo('D', 'LCtrl'), pressed = iCommandLeftWheelBrake, up = iCommandLeftWheelBrake, value_pressed = -1, value_up = 1, category = { categories.gears_brakes_hook, categories.pedals } },
    { name = _('Wheel Brake (Right)'), combos = combo('D', 'LAlt'), pressed = iCommandRightWheelBrake, up = iCommandRightWheelBrake, value_pressed = -1, value_up = 1, category = { categories.gears_brakes_hook, categories.pedals } },

    switch_2('Emergency Wheel Brake', { 'Deactivate', 'Activate' }, device_commands.LANDING_GEAR_Pilot_Emergency_Brakes, device_commands.LANDING_GEAR_Pilot_Emergency_Brakes_TOGGLE, device_commands.LANDING_GEAR_Pilot_Emergency_Brakes_AXIS, { cockpit_device_id = devices.GEARANDHOOK, category = { categories.gears_brakes_hook, categories.main_panel } }),

    switch_2('Drag-Parachute', { 'In', 'Deploy' }, device_commands.PARACHUTE_DEPLOY, nil, nil, bind_templates.parachute(), { category = { categories.parachute, categories.seat, categories.gears_brakes_hook, categories.essentials }, binds = { pos_1 = { combos = combo('P') } } }), --TODO Toggle is missing
    push_button('Release Drag-Parachute', device_commands.PARACHUTE_RELEASE, nil, bind_templates.parachute(), { category = { categories.parachute, categories.seat, categories.gears_brakes_hook, categories.essentials }, binds = { push = { combos = combo('P', 'RShift') } } }),

    --*************** Radar & Maverick *********************************************************************
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Right'), combos = combo('/'), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = 0.5, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Left'), combos = combo(','), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = -0.5, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Up'), combos = combo(';'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = 0.5, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Down'), combos = combo('.'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = -0.5, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Right (fast)'), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = 1, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Left (fast)'), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = -1, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Up (fast)'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = 1, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Down (fast)'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = -1, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Right (slow)'), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = 0.25, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Left (slow)'), down = device_commands.MAVERICK_SLEW_XAxisKey, up = device_commands.MAVERICK_SLEW_XAxisKey, value_down = -0.25, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Up (slow)'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = 0.25, value_up = 0 }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) - Down (slow)'), down = device_commands.MAVERICK_SLEW_YAxisKey, up = device_commands.MAVERICK_SLEW_YAxisKey, value_down = -0.25, value_up = 0 }),

    --*************** Range Indicator *********************************************************************
    push_button('Test Button', device_commands.PILOT_RANGE_INDICATOR_TEST_BUTTON, device_commands.PILOT_RANGE_INDICATOR_TEST_BUTTON_AXIS, bind_templates.range_indicator()),
    knob_inc_dec('Range Display Brightness', nil, 0.01, device_commands.PILOT_RANGE_INDICATOR_DISPLAY_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_RANGE_INDICATOR_DISPLAY_BRIGHTNESS_KNOB_AXIS, bind_templates.range_indicator()),
    knob_inc_dec_variants('Desired Release Range', nil, 0.00125, 0.00015, 0.005, device_commands.PILOT_RANGE_INDICATOR_DESIRED_RANGE_KNOB_INC_DEC, device_commands.PILOT_RANGE_INDICATOR_DESIRED_RANGE_KNOB_INC_DEC_ACCELERATING, device_commands.PILOT_RANGE_INDICATOR_DESIRED_RANGE_KNOB_AXIS, bind_templates.range_indicator()),
    switch_3_0_to_1('Range Mode', { 'WRCS', 'SET', 'ROR' }, { '[Left]', '[Right]' }, device_commands.PILOT_RANGE_INDICATOR_MODE_SELECTOR_SWITCH, device_commands.PILOT_RANGE_INDICATOR_MODE_SELECTOR_SWITCH_INC_DEC, device_commands.PILOT_RANGE_INDICATOR_MODE_SELECTOR_SWITCH_NEXT, device_commands.PILOT_RANGE_INDICATOR_MODE_SELECTOR_SWITCH_AXIS, bind_templates.range_indicator()),

    --*************** RWR *********************************************************************
    knob_inc_dec('RWR Display Brightness', nil, 0.01, device_commands.PILOT_RWR_KNOB_INC_DEC, device_commands.PILOT_RWR_KNOB_AXIS, bind_templates.rwr_panel_pilot()),

    knob_inc_dec('RWR Audio Volume', nil, 0.01, device_commands.PILOT_APR_AUDIO_KNOB_INC_DEC, device_commands.PILOT_APR_AUDIO_KNOB_AXIS, bind_templates.rwr_panel_pilot()),
    knob_inc_dec('RWR Buttons Light Brightness', nil, 0.01, device_commands.PILOT_APR_DIM_KNOB_INC_DEC, device_commands.PILOT_APR_DIM_KNOB_AXIS, bind_templates.rwr_panel_pilot()),

    push_button('Priority/Open Mode Button', device_commands.PILOT_RWR_I_BAND, device_commands.PILOT_RWR_I_BAND_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('Search Button', device_commands.PILOT_RWR_G_BAND, device_commands.PILOT_RWR_G_BAND_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('Handoff Button', device_commands.PILOT_RWR_E_BAND, device_commands.PILOT_RWR_E_BAND_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('Low/Altitude Button', device_commands.PILOT_RWR_AAA_DEFEAT, device_commands.PILOT_RWR_AAA_DEFEAT_AXIS, bind_templates.rwr_panel_pilot()),

    push_button('Target Separation Button', device_commands.PILOT_RWR_AI, device_commands.PILOT_RWR_AI_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('RWR BIT Button', device_commands.PILOT_RWR_LORO, device_commands.PILOT_RWR_LORO_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('Unknown Button', device_commands.PILOT_RWR_AAA_GCI, device_commands.PILOT_RWR_AAA_GCI_AXIS, bind_templates.rwr_panel_pilot()),
    push_button('RWR Power Button', device_commands.PILOT_RWR_SYSTEM_POWER, device_commands.PILOT_RWR_SYSTEM_POWER_AXIS, bind_templates.rwr_panel_pilot()),

    --*************** Electrics *********************************************************************
    switch_3('Generator (Left)', { 'External', 'Off', 'On' }, nil, device_commands.PILOT_L_GEN_SWITCH, device_commands.PILOT_L_GEN_SWITCH_INC_DEC, device_commands.PILOT_L_GEN_SWITCH_NEXT, device_commands.PILOT_L_GEN_SWITCH_AXIS, bind_templates.generators()),
    switch_3('Generator (Right)', { 'External', 'Off', 'On' }, nil, device_commands.PILOT_R_GEN_SWITCH, device_commands.PILOT_R_GEN_SWITCH_INC_DEC, device_commands.PILOT_R_GEN_SWITCH_NEXT, device_commands.PILOT_R_GEN_SWITCH_AXIS, bind_templates.generators()),

    --*************** Altimeter *********************************************************************
    knob_inc_dec('Altimeter Reference Pressure', nil, 0.001, device_commands.PILOT_ALTIMETER_Knob_INC_DEC, device_commands.PILOT_ALTIMETER_Knob_AXIS, bind_templates.altimeter()),
    switch_3_springloaded_both('Altimeter Mode', { 'Standby', 'Neutral', 'Reset to Primary' }, { '[Right]', '[Left]' }, device_commands.ALTIMETER_Mode, device_commands.PILOT_ALTIMETER_Mode_INC_DEC, device_commands.PILOT_ALTIMETER_Mode_AXIS, bind_templates.altimeter()), --TODO Left/Right skips over center position

    --*************** Radar Altimeter *********************************************************************
    push_button('Test Radar Altimeter', device_commands.RADAR_ALTIMETER_Test, device_commands.RADAR_ALTIMETER_Test_AXIS, bind_templates.radar_altimeter()),
    knob_inc_dec_variants('Radar Altimeter Low Altitude Warning', nil, 0.005, 0.001, 0.01, device_commands.RADAR_ALTIMETER_LowAltSet_INC_DEC, device_commands.RADAR_ALTIMETER_LowAltSet_INC_DEC_ACCELERATING, device_commands.RADAR_ALTIMETER_LowAltSet_AXIS, bind_templates.radar_altimeter()),

    --*************** ICS Panel *********************************************************************
    knob_inc_dec('ICS Volume', nil, 0.01, device_commands.PILOT_ICS_PANEL_VOLUME_KNOB_INC_DEC, device_commands.PILOT_ICS_PANEL_VOLUME_KNOB_AXIS, bind_templates.ics_panel()),
    switch_3_springloaded_up('Intercom Mode', { 'Cold Mic', 'Hot Mic', 'Radio Override' }, nil, device_commands.PILOT_ICS_PANEL_MIC_SWITCH, device_commands.PILOT_ICS_PANEL_MIC_SWITCH_INC_DEC, device_commands.PILOT_ICS_PANEL_MIC_SWITCH_NEXT, device_commands.PILOT_ICS_PANEL_MIC_SWITCH_AXIS, bind_templates.ics_panel()),
    knob('Amplifier Selector', { 'Backup', 'Normal', 'Emergency' }, nil, device_commands.PILOT_ICS_PANEL_AMPLIFIER_SELECTOR, device_commands.PILOT_ICS_PANEL_AMPLIFIER_SELECTOR_INC_DEC, device_commands.PILOT_ICS_PANEL_AMPLIFIER_SELECTOR_NEXT, device_commands.PILOT_ICS_PANEL_AMPLIFIER_SELECTOR_AXIS, bind_templates.ics_panel()),
    
    --*************** KY-28 Indicators **************************************************************
    push_button('KY-28 P Mode Light Test', device_commands.PILOT_KY28_P_MODE_LIGHT_PRESS, nil, bind_templates.ky28_panel()),
    knob_inc_dec('KY-28 P Mode Light Dim', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_KY28_P_MODE_LIGHT_ROTATION_INC_DEC, device_commands.PILOT_KY28_P_MODE_LIGHT_ROTATION_AXIS, bind_templates.ky28_panel()),
    push_button('KY-28 C Mode Light Test', device_commands.PILOT_KY28_C_MODE_LIGHT_PRESS, nil, bind_templates.ky28_panel()),
    knob_inc_dec('KY-28 C Mode Light Dim', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_KY28_C_MODE_LIGHT_ROTATION_INC_DEC, device_commands.PILOT_KY28_C_MODE_LIGHT_ROTATION_AXIS, bind_templates.ky28_panel()),

    --*************** IFF Panel *********************************************************************
    knob('IFF Master Switch', { 'Off', 'Stby', 'Low', 'Norm', 'Emerg' }, nil, device_commands.PILOT_IFF_MASTER_Knob, device_commands.PILOT_IFF_MASTER_Knob_INC_DEC, device_commands.PILOT_IFF_MASTER_Knob_NEXT, device_commands.PILOT_IFF_MASTER_Knob_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 4 Function', { 'Hold', 'A', 'B', 'ZERO' }, nil, device_commands.PILOT_IFF_CODE_Knob, device_commands.PILOT_IFF_CODE_Knob_INC_DEC, device_commands.PILOT_IFF_CODE_Knob_NEXT, device_commands.PILOT_IFF_CODE_Knob_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Mode 4 Indication', { 'Light', 'Out', 'Audio' }, nil, device_commands.PILOT_IFF_AUDIO_LIGHT_SW, device_commands.PILOT_IFF_AUDIO_LIGHT_SW_INC_DEC, device_commands.PILOT_IFF_AUDIO_LIGHT_SW_NEXT, device_commands.PILOT_IFF_AUDIO_LIGHT_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Mode 1 Selector', { 'Out', 'On', 'Test' }, nil, device_commands.PILOT_IFF_M1_SW, device_commands.PILOT_IFF_M1_SW_INC_DEC, device_commands.PILOT_IFF_M1_SW_NEXT, device_commands.PILOT_IFF_M1_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Mode 2 Selector', { 'Out', 'On', 'Test' }, nil, device_commands.PILOT_IFF_M2_SW, device_commands.PILOT_IFF_M2_SW_INC_DEC, device_commands.PILOT_IFF_M2_SW_NEXT, device_commands.PILOT_IFF_M2_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Mode 3 Selector', { 'Out', 'On', 'Test' }, nil, device_commands.PILOT_IFF_M3_SW, device_commands.PILOT_IFF_M3_SW_INC_DEC, device_commands.PILOT_IFF_M3_SW_NEXT, device_commands.PILOT_IFF_M3_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Mode C Selector', { 'Out', 'On', 'Test' }, nil, device_commands.PILOT_IFF_MC_SW, device_commands.PILOT_IFF_MC_SW_INC_DEC, device_commands.PILOT_IFF_MC_SW_NEXT, device_commands.PILOT_IFF_MC_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Monitor-Radiation', { 'Monitor', 'Out', 'Radiation Test' }, nil, device_commands.PILOT_IFF_RAD_TEST_SW, device_commands.PILOT_IFF_RAD_TEST_SW_INC_DEC, device_commands.PILOT_IFF_RAD_TEST_SW_NEXT, device_commands.PILOT_IFF_RAD_TEST_SW_AXIS, bind_templates.iff_panel()),
    switch_3('IFF Identification', { 'Mic', 'Out', 'Ident' }, nil, device_commands.PILOT_IFF_IDENT_MIC_SW, device_commands.PILOT_IFF_IDENT_MIC_SW_INC_DEC, device_commands.PILOT_IFF_IDENT_MIC_SW_NEXT, device_commands.PILOT_IFF_IDENT_MIC_SW_AXIS, bind_templates.iff_panel()),
    switch_2('IFF Mode 4 Selector', nil, device_commands.PILOT_IFF_M4_SW, device_commands.PILOT_IFF_M4_SW_TOGGLE, device_commands.PILOT_IFF_M4_SW_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 1 Code Digit 1', { '0', '1', '2', '3', '4', '5', '6', '7' }, nil, device_commands.PILOT_IFF_MODE1_CODE_TENS, device_commands.PILOT_IFF_MODE1_CODE_TENS_INC_DEC, device_commands.PILOT_IFF_MODE1_CODE_TENS_NEXT, device_commands.PILOT_IFF_MODE1_CODE_TENS_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 1 Code Digit 2', { '0', '1', '2', '3' }, nil, device_commands.PILOT_IFF_MODE1_CODE_ONES, device_commands.PILOT_IFF_MODE1_CODE_ONES_INC_DEC, device_commands.PILOT_IFF_MODE1_CODE_ONES_NEXT, device_commands.PILOT_IFF_MODE1_CODE_ONES_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 3 Code Digit 1', { '0', '1', '2', '3', '4', '5', '6', '7' }, nil, device_commands.PILOT_IFF_MODE3_CODE_THOUSANDS, device_commands.PILOT_IFF_MODE3_CODE_THOUSANDS_INC_DEC, device_commands.PILOT_IFF_MODE3_CODE_THOUSANDS_NEXT, device_commands.PILOT_IFF_MODE3_CODE_THOUSANDS_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 3 Code Digit 2', { '0', '1', '2', '3', '4', '5', '6', '7' }, nil, device_commands.PILOT_IFF_MODE3_CODE_HUNDREDS, device_commands.PILOT_IFF_MODE3_CODE_HUNDREDS_INC_DEC, device_commands.PILOT_IFF_MODE3_CODE_HUNDREDS_NEXT, device_commands.PILOT_IFF_MODE3_CODE_HUNDREDS_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 3 Code Digit 3', { '0', '1', '2', '3', '4', '5', '6', '7' }, nil, device_commands.PILOT_IFF_MODE3_CODE_TENS, device_commands.PILOT_IFF_MODE3_CODE_TENS_INC_DEC, device_commands.PILOT_IFF_MODE3_CODE_TENS_NEXT, device_commands.PILOT_IFF_MODE3_CODE_TENS_AXIS, bind_templates.iff_panel()),
    knob('IFF Mode 3 Code Digit 4', { '0', '1', '2', '3', '4', '5', '6', '7' }, nil, device_commands.PILOT_IFF_MODE3_CODE_ONES, device_commands.PILOT_IFF_MODE3_CODE_ONES_INC_DEC, device_commands.PILOT_IFF_MODE3_CODE_ONES_NEXT, device_commands.PILOT_IFF_MODE3_CODE_ONES_AXIS, bind_templates.iff_panel()),

    --*************** UHF Radio *********************************************************************
    knob_inc_dec('Radio Command Light Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.UHF_COMM_CMD_Brightness_INC_DEC, device_commands.UHF_COMM_CMD_Brightness_AXIS, bind_templates.uhf_panel_pilot()),
    push_button('Toggle Radio Command', device_commands.UHF_COMM_CMD_Button, device_commands.UHF_COMM_CMD_Button_AXIS, bind_templates.uhf_panel_pilot()),
    knob_inc_dec('UHF Volume', nil, 0.01, device_commands.PILOT_UHF_Volume_Control_INC_DEC, device_commands.PILOT_UHF_Volume_Control_AXIS, bind_templates.uhf_panel_pilot()),
    switch_2('UHF Squelch', nil, device_commands.UHF_SQUELCH_SWITCH, device_commands.UHF_SQUELCH_SWITCH_TOGGLE, device_commands.UHF_SQUELCH_SWITCH_AXIS, bind_templates.uhf_panel_pilot()),

    knob('Comm Frequency (0xx.xxx)', { 'T', '2', '3', 'A' }, { '[Dec]', '[Inc]' }, device_commands.UHF_FREQ_KNOB_HUNDREDS, device_commands.PILOT_UHF_FREQ_KNOB_HUNDREDS_INC_DEC, device_commands.PILOT_UHF_FREQ_KNOB_HUNDREDS_NEXT, device_commands.PILOT_UHF_FREQ_KNOB_HUNDREDS_AXIS, bind_templates.uhf_panel_pilot()),
    knob('Comm Frequency (x0x.xxx)', { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' }, { '[Dec]', '[Inc]' }, device_commands.UHF_Freq_Knob_Tens, device_commands.PILOT_UHF_FREQ_KNOB_TENS_INC_DEC, device_commands.PILOT_UHF_FREQ_KNOB_TENS_NEXT, device_commands.PILOT_UHF_FREQ_KNOB_TENS_AXIS, bind_templates.uhf_panel_pilot()),
    knob('Comm Frequency (xx0.xxx)', { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' }, { '[Dec]', '[Inc]' }, device_commands.UHF_Freq_Knob_Ones, device_commands.PILOT_UHF_FREQ_KNOB_ONES_INC_DEC, device_commands.PILOT_UHF_FREQ_KNOB_ONES_NEXT, device_commands.PILOT_UHF_FREQ_KNOB_ONES_AXIS, bind_templates.uhf_panel_pilot()),
    knob('Comm Frequency (xxx.0xx)', { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' }, { '[Dec]', '[Inc]' }, device_commands.UHF_Freq_Knob_DecOnes, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_ONES_INC_DEC, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_ONES_NEXT, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_ONES_AXIS, bind_templates.uhf_panel_pilot()),
    knob('Comm Frequency (xxx.x00)', { '0', '25', '50', '75' }, { '[Dec]', '[Inc]' }, device_commands.UHF_Freq_Knob_DecHundreds, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_HUNDREDS_INC_DEC, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_HUNDREDS_NEXT, device_commands.PILOT_UHF_FREQ_KNOB_DECIMAL_HUNDREDS_AXIS, bind_templates.uhf_panel_pilot()),

    knob('Comm Channel', { '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18' }, { '[Dec]', '[Inc]' }, device_commands.UHF_Communication_Channel_Control_Knob, device_commands.PILOT_UHF_Communication_Channel_Control_Knob_INC_DEC, device_commands.PILOT_UHF_Communication_Channel_Control_Knob_NEXT, device_commands.PILOT_UHF_Communication_Channel_Control_Knob_AXIS, bind_templates.uhf_panel_pilot()),
    knob('AUX Channel', { '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20' }, { '[Dec]', '[Inc]' }, device_commands.UHF_AUX_Channel_Control_Knob, device_commands.PILOT_UHF_AUX_Channel_Control_Knob_INC_DEC, device_commands.PILOT_UHF_AUX_Channel_Control_Knob_NEXT, device_commands.PILOT_UHF_AUX_Channel_Control_Knob_AXIS, bind_templates.uhf_panel_pilot()),

    push_button('Load Comm Channel', device_commands.UHF_Set_Channel_Pushbutton, device_commands.UHF_Set_Channel_Pushbutton_AXIS, bind_templates.uhf_panel_pilot()),
    switch_2('Frequency Mode', { 'Preset', 'Manual' }, device_commands.UHF_MODE_SELECTOR_SWITCH, device_commands.UHF_MODE_SELECTOR_SWITCH_TOGGLE, device_commands.UHF_MODE_SELECTOR_SWITCH_AXIS, bind_templates.uhf_panel_pilot()),

    knob('Radio Mode', { 'Off', 'T/R & ADF', 'T/R+G & ADF', 'ADF+G & CMD', 'ADF & G', 'Guard & ADF' }, nil, device_commands.UHF_Mode_Selector_Knob, device_commands.PILOT_UHF_Mode_Selector_Knob_INC_DEC, device_commands.PILOT_UHF_Mode_Selector_Knob_NEXT, device_commands.PILOT_UHF_Mode_Selector_Knob_AXIS, bind_templates.uhf_panel_pilot()),
    knob_inc_dec('AUX Volume', nil, 0.01, device_commands.PILOT_UHF_AUX_Volume_Control_INC_DEC, device_commands.PILOT_UHF_AUX_Volume_Control_AXIS, bind_templates.uhf_panel_pilot()),

    --*************** DSCG Panel *********************************************************************
    switch_2('Collimator Shutter', { 'Open', 'Close' }, device_commands.HUD_AdjustShutter, device_commands.HUD_AdjustShutter_TOGGLE, device_commands.HUD_AdjustShutter_AXIS, bind_templates.hud_controls()),
    knob_inc_dec('Scale Brightness', nil, 0.01, device_commands.PILOT_DSCG_SCALE_INC_DEC, device_commands.PILOT_DSCG_SCALE_AXIS, bind_templates.dscg_panel()),
    knob_inc_dec('Reticle Brightness', nil, 0.01, device_commands.HUD_AdjustIntensity_INC_DEC, device_commands.HUD_AdjustIntensity_AXIS, bind_templates.hud_controls()),
    knob_inc_dec('Screen Contrast', nil, 0.01, device_commands.PILOT_DSCG_CONTRAST_INC_DEC, device_commands.PILOT_DSCG_CONTRAST_AXIS, bind_templates.dscg_panel()),
    knob_inc_dec('Screen Brightness', nil, 0.01, device_commands.PILOT_DSCG_BRIGHTNESS_INC_DEC, device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, bind_templates.dscg_panel()),
    -- TODO Not simulated yet: knob_inc_dec('DSCG Horizon Line', { 'Up', 'Down' }, 0.01, device_commands.PILOT_DSCG_HORIZONTAL_LINE_INC_DEC, device_commands.PILOT_DSCG_HORIZONTAL_LINE_AXIS, bind_templates.dscg_panel()),

    knob_inc_dec_variants('Reticle Depression', nil, 0.001, 0.0002, 0.005, device_commands.HUD_AdjustReticle_INC_DEC, device_commands.HUD_AdjustReticle_INC_DEC_ACCELERATING, device_commands.HUD_AdjustReticle_AXIS, bind_templates.hud_controls()),
    knob('HUD Mode', { 'Off', 'Standby', 'Cage', 'A/G', 'A/A', 'BIT 1', 'BIT 2' }, nil, device_commands.HUD_SelectHUDMode, device_commands.HUD_SelectHUDMode_INC_DEC, device_commands.HUD_SelectHUDMode_NEXT, device_commands.HUD_SelectHUDMode_AXIS, bind_templates.hud_controls()),

    switch_3_0_to_1('DSCG Screen Mode', { 'Radar', 'Off', 'Tv' }, { '[Up]', '[Down]' }, device_commands.PILOT_DSCG_MODE, device_commands.PILOT_DSCG_MODE_INC_DEC, device_commands.PILOT_DSCG_MODE_NEXT, device_commands.PILOT_DSCG_MODE_AXIS, bind_templates.dscg_panel(), { category = { categories.dscg, categories.center_panel } }),

    knob_inc_dec('Screen Intensity', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_DSCG_POLARITY_INC_DEC, device_commands.PILOT_DSCG_POLARITY_AXIS, bind_templates.dscg_panel()),
    switch_2('Screen Night Filter (Red)', nil, device_commands.PILOT_DSCG_NIGHT_FILTER, device_commands.PILOT_DSCG_NIGHT_FILTER_TOGGLE, device_commands.PILOT_DSCG_NIGHT_FILTER_AXIS, bind_templates.dscg_panel()),

    --*************** Oxygen *********************************************************************
    push_button('Oxygen Test Button', device_commands.OXYGENSYSTEM_Test_System, device_commands.OXYGENSYSTEM_Test_System_AXIS, bind_templates.oxygen_pilot()),

    switch_3_springloaded_down('Oxygen Mode', { 'Test Mask', 'Normal', 'Emergency' }, nil, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Pressure, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Pressure_INC_DEC, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Pressure_NEXT, nil, bind_templates.oxygen_pilot()),
    switch_2('Oxygen Mixture', { 'Normal', '100% Oxygen' }, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Ratio, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Ratio_TOGGLE, nil, bind_templates.oxygen_pilot()),
    switch_2('Oxygen Supply', { 'On', 'Off' }, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Supply, device_commands.OXYGENSYSTEM_Pilot_Set_Ox_Supply_TOGGLE, nil, bind_templates.oxygen_pilot()),

    --*************** Fuel System Panel *********************************************************************
    switch_2('Internal Wing Tanks Feed', { 'Normal', 'Stop' }, device_commands.PILOT_FUELSYS_INT_WING_TRANS_SWITCH, device_commands.PILOT_FUELSYS_INT_WING_TRANS_SWITCH_TOGGLE, device_commands.PILOT_FUELSYS_INT_WING_TRANS_SWITCH_AXIS, bind_templates.fuel_system_panel()),
    switch_2('Refuel Tank Selector Cover', { 'Close', 'Open' }, device_commands.PILOT_FUELSYS_REFUEL_SEL_COVER, nil, nil, bind_templates.fuel_system_panel()), -- TODO Missing Toggle
    switch_2('Select Tank to Refuel', { 'All Tanks', 'Internal Tanks' }, device_commands.PILOT_FUELSYS_REFUEL_SEL_SWITCH, device_commands.PILOT_FUELSYS_REFUEL_SEL_SWITCH_TOGGLE, device_commands.PILOT_FUELSYS_REFUEL_SEL_SWITCH_AXIS, bind_templates.fuel_system_panel()),
    switch_2('Air Refuel Switch', { 'Retract', 'Extend' }, device_commands.PILOT_FUELSYS_AIR_REFUEL_SWITCH, device_commands.PILOT_FUELSYS_AIR_REFUEL_SWITCH_TOGGLE, device_commands.PILOT_FUELSYS_AIR_REFUEL_SWITCH_AXIS, bind_templates.fuel_system_panel()),

    switch_2('Wing Fuel Dump Selector', { 'Normal', 'Dump' }, device_commands.PILOT_FUELSYS_INT_WING_DUMP_SWITCH, device_commands.PILOT_FUELSYS_INT_WING_DUMP_SWITCH_TOGGLE, device_commands.PILOT_FUELSYS_INT_WING_DUMP_SWITCH_AXIS, bind_templates.fuel_system_panel()),
    switch_3('External Tanks Feed', { 'Center', 'Off', 'Outboard' }, nil, device_commands.PILOT_FUELSYS_EXT_WING_TRANS_SWITCH, device_commands.PILOT_FUELSYS_EXT_WING_TRANS_SWITCH_INC_DEC, device_commands.PILOT_FUELSYS_EXT_WING_TRANS_SWITCH_NEXT, device_commands.PILOT_FUELSYS_EXT_WING_TRANS_SWITCH_AXIS, bind_templates.fuel_system_panel()),

    switch_2_springloaded_up('Left Boost Pump Test', { 'Normal', 'Check' }, device_commands.PILOT_FUEL_PANEL_LEFT_BOOST_PUMP_SWITCH, device_commands.PILOT_FUEL_PANEL_LEFT_BOOST_PUMP_SWITCH_TOGGLE, device_commands.PILOT_FUEL_PANEL_LEFT_BOOST_PUMP_SWITCH_AXIS, bind_templates.fuel_system_panel()),
    switch_2_springloaded_up('Right Boost Pump Test', { 'Normal', 'Check' }, device_commands.PILOT_FUEL_PANEL_RIGHT_BOOST_PUMP_SWITCH, device_commands.PILOT_FUEL_PANEL_RIGHT_BOOST_PUMP_SWITCH_TOGGLE, device_commands.PILOT_FUEL_PANEL_RIGHT_BOOST_PUMP_SWITCH_AXIS, bind_templates.fuel_system_panel()),

    --*************** TACAN *********************************************************************
    knob_inc_dec('TACAN Volume', { '[Dec]', '[Inc]' }, 0.01, device_commands.TACAN_Volume_INC_DEC, device_commands.TACAN_Volume_AXIS, bind_templates.tacan_panel_pilot()),
    knob('TACAN Channel (00xx)', { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12' }, { '[Dec]', '[Inc]' }, device_commands.TACAN_CHAN_TensAndMore, device_commands.TACAN_CHAN_TensAndMore_INC_DEC, device_commands.TACAN_CHAN_TensAndMore_NEXT, device_commands.TACAN_CHAN_TensAndMore_AXIS, bind_templates.tacan_panel_pilot()),
    push_button('TACAN Test Button', device_commands.TACAN_TEST_BUTTON, device_commands.TACAN_TEST_BUTTON_AXIS, bind_templates.tacan_panel_pilot()),
    knob('TACAN Channel (xx0x)', { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' }, { '[Dec]', '[Inc]' }, device_commands.TACAN_CHAN_Ones, device_commands.TACAN_CHAN_Ones_INC_DEC, device_commands.TACAN_CHAN_Ones_NEXT, device_commands.TACAN_CHAN_Ones_AXIS, bind_templates.tacan_panel_pilot()),
    knob('TACAN Channel (xxx0)', { 'X', 'Y' }, { '[Dec]', '[Inc]' }, device_commands.TACAN_CHAN_XY, device_commands.TACAN_CHAN_XY_INC_DEC, device_commands.TACAN_CHAN_XY_NEXT, device_commands.TACAN_CHAN_XY_AXIS, bind_templates.tacan_panel_pilot()),
    knob('TACAN Mode', { 'Off', 'Receive Only', 'T/R', 'A/A Receive', 'A/A T/R' }, { '[Dec]', '[Inc]' }, device_commands.TACAN_Function_Selector, device_commands.TACAN_Function_Selector_INC_DEC, device_commands.TACAN_Function_Selector_TOGGLE, device_commands.TACAN_Function_Selector_AXIS, bind_templates.tacan_panel_pilot()),

    push_button('Toggle TACAN Command', device_commands.TACAN_PILOT_COMMAND, device_commands.TACAN_PILOT_COMMAND_AXIS, bind_templates.tacan_panel_pilot()),
    knob_inc_dec('TACAN Command Light Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.UHF_NAV_CMD_Brightness_INC_DEC, device_commands.UHF_NAV_CMD_Brightness_AXIS, bind_templates.tacan_panel_pilot()),

    --*************** Compass Panel *********************************************************************
    -- TODO Add Compass Heading Knob, but frontend is fairly complex
    knob_springloaded_last('Compass Mode', { 'Compass', 'DG', 'Slaved', 'Sync' }, nil, device_commands.PILOT_COMPASS_PILOT_MODE_SELECTOR_KNOB, device_commands.PILOT_COMPASS_PILOT_MODE_SELECTOR_KNOB_INC_DEC, device_commands.PILOT_COMPASS_PILOT_MODE_SELECTOR_KNOB_NEXT, device_commands.PILOT_COMPASS_PILOT_MODE_SELECTOR_KNOB_AXIS, bind_templates.compass_panel()),
    knob_inc_dec('Compass Latitude', nil, 0.01, device_commands.PILOT_COMPASS_PILOT_LATITUDE_CTRL_KNOB_INC_DEC, device_commands.PILOT_COMPASS_PILOT_LATITUDE_CTRL_KNOB_AXIS, bind_templates.compass_panel()),

    --*************** Navigation Panel *********************************************************************
    knob('Navigation Input', { 'VOR & TACAN', 'TACAN', 'ADF & TACAN', 'Navigation Computer' }, nil, device_commands.NAV_FUNCT_SEL_PANEL_BRG_DIST_SELECTOR, device_commands.NAV_FUNCT_SEL_PANEL_BRG_DIST_SELECTOR_INC_DEC, device_commands.NAV_FUNCT_SEL_PANEL_BRG_DIST_SELECTOR_NEXT, device_commands.NAV_FUNCT_SEL_PANEL_BRG_DIST_SELECTOR_AXIS, bind_templates.navigation_panel_pilot()),
    knob('Navigation Mode', { 'VOR & ILS', 'TACAN', 'Navigation Computer', 'Heading' }, nil, device_commands.NAV_FUNCT_SEL_PANEL_SOURCE_MODE_SELECTOR, device_commands.NAV_FUNCT_SEL_PANEL_SOURCE_MODE_SELECTOR_INC_DEC, device_commands.NAV_FUNCT_SEL_PANEL_SOURCE_MODE_SELECTOR_NEXT, device_commands.NAV_FUNCT_SEL_PANEL_SOURCE_MODE_SELECTOR_AXIS, bind_templates.navigation_panel_pilot()),
    switch_2('Flight Director Switch', { 'Off', 'On' }, device_commands.NAV_FUNCT_SEL_PANEL_FD_KNOB, device_commands.NAV_FUNCT_SEL_PANEL_FD_KNOB_TOGGLE, device_commands.NAV_FUNCT_SEL_PANEL_FD_KNOB_AXIS, bind_templates.navigation_panel_pilot()),

    --*************** HSI *********************************************************************
    knob_inc_dec_variants('HSI Heading', nil, 0.008, 0.003, 0.05, device_commands.PILOT_HSI_HEADING_SET_KNOB, device_commands.PILOT_HSI_HEADING_SET_KNOB_ACCELERATING, nil, bind_templates.hsi()),
    knob_inc_dec_variants('HSI Course', nil, 0.004, 0.001, 0.008, device_commands.PILOT_HSI_COURSE_SET_KNOB, device_commands.PILOT_HSI_COURSE_SET_KNOB_ACCELERATING, nil, bind_templates.hsi()),

    --*************** CMS Panel *********************************************************************
    knob('Chaff Burst Count', { '1', '2', '3', '4', '6', '8' }, nil, device_commands.CHAFF_BURST_COUNT, device_commands.CHAFF_BURST_COUNT_INC_DEC, device_commands.CHAFF_BURST_COUNT_NEXT, device_commands.CHAFF_BURST_COUNT_AXIS, bind_templates.cms_panel()),
    knob('Chaff Burst Interval', { '1', '2', '3', '4' }, nil, device_commands.CHAFF_BURST_INTERVAL, device_commands.CHAFF_BURST_INTERVAL_INC_DEC, device_commands.CHAFF_BURST_INTERVAL_NEXT, device_commands.CHAFF_BURST_INTERVAL_AXIS, bind_templates.cms_panel()),

    knob('Chaff Salvo Count', { '1', '2', '4', '8', 'C' }, nil, device_commands.CHAFF_SALVO_COUNT, device_commands.CHAFF_SALVO_COUNT_INC_DEC, device_commands.CHAFF_SALVO_COUNT_NEXT, device_commands.CHAFF_SALVO_COUNT_AXIS, bind_templates.cms_panel()),
    knob('Chaff Salvo Interval', { '1', '2', '3', '4', '5', '8', 'R' }, nil, device_commands.CHAFF_SALVO_INTERVAL, device_commands.CHAFF_SALVO_INTERVAL_INC_DEC, device_commands.CHAFF_SALVO_INTERVAL_NEXT, device_commands.CHAFF_SALVO_INTERVAL_AXIS, bind_templates.cms_panel()),

    knob('Flare Burst Count', { '1', '2', '4', '8', 'C' }, nil, device_commands.FLARE_BURST_COUNT, device_commands.FLARE_BURST_COUNT_INC_DEC, device_commands.FLARE_BURST_COUNT_NEXT, device_commands.FLARE_BURST_COUNT_AXIS, bind_templates.cms_panel()),
    knob('Flare Burst Interval', { '3', '4', '6', '8', '10' }, nil, device_commands.FLARE_BURST_INTERVAL, device_commands.FLARE_BURST_INTERVAL_INC_DEC, device_commands.FLARE_BURST_INTERVAL_NEXT, device_commands.FLARE_BURST_INTERVAL_AXIS, bind_templates.cms_panel()),

    push_button('Test CMS Indicator', device_commands.ALE40_ON_LIGHT_PRESS, device_commands.ALE40_ON_LIGHT_PRESS_AXIS, bind_templates.cms_panel()),
    knob_inc_dec('CMS Indicator Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.ALE40_ON_LIGHT_ROTATION_INC_DEC, device_commands.ALE40_ON_LIGHT_ROTATION_AXIS, bind_templates.cms_panel()),
    push_button('Test Flare Indicator', device_commands.ALE40_FLARES_LIGHT_PRESS, device_commands.ALE40_FLARES_LIGHT_PRESS_AXIS, bind_templates.cms_panel()),
    knob_inc_dec('Flare Indicator Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.ALE40_FLARES_LIGHT_ROTATION_INC_DEC, device_commands.ALE40_FLARES_LIGHT_ROTATION_AXIS, bind_templates.cms_panel()),

    switch_2('Dispense Program', { 'Normal', 'Flares' }, device_commands.FLARES_SELECT, device_commands.FLARES_SELECT_TOGGLE, device_commands.FLARES_SELECT_AXIS, bind_templates.cms_panel()),

    --*************** Clock *********************************************************************
    push_button('Stopwatch Button', device_commands.STOPWATCH_PILOT_PRESS, device_commands.STOPWATCH_PILOT_PRESS_AXIS, bind_templates.clock()),
    switch_2('Clock Button', { 'In', 'Out' }, device_commands.CLOCK_PILOT_KNOB_PRESS, device_commands.CLOCK_PILOT_KNOB_PRESS_TOGGLE, device_commands.CLOCK_PILOT_KNOB_PRESS_AXIS, bind_templates.clock()),
    knob_inc_dec('Clock Knob Rotate', nil, 0.015, device_commands.CLOCK_PILOT_KNOB_ROTATE, nil, bind_templates.clock()),

    --*************** Light Wall Panel *********************************************************************
    switch_3_0_to_1_springloaded_down('Formation Lights Mode', { 'Momentary', 'Off', 'On' }, nil, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_MODE_SWITCH, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_MODE_SWITCH_INC_DEC, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_MODE_SWITCH_NEXT, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_MODE_SWITCH_AXIS, bind_templates.lights_wall_panel()),
    knob_inc_dec('Formation Lights Brightness', nil, 0.01, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_RIGHT_WALL_FORMATION_LIGHTS_BRIGHTNESS_KNOB_AXIS, bind_templates.lights_wall_panel()),
    knob_inc_dec('AoA Indexer Brightness', nil, 0.01, device_commands.PILOT_RIGHT_WALL_INDEXER_LIGHT_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_RIGHT_WALL_INDEXER_LIGHT_BRIGHTNESS_KNOB_AXIS, { cockpit_device_id = devices.INTERIOR_LIGHTS, category = { categories.lights, categories.right_wall } }),

    --*************** Exterior Lights Panel *********************************************************************
    switch_3_0_to_1('Fus & Anti-Col Lights', { 'Dim', 'Off', 'Bright' }, nil, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_FUSELAGE_SWITCH, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_FUSELAGE_SWITCH_INC_DEC, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_FUSELAGE_SWITCH_NEXT, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_FUSELAGE_SWITCH_AXIS, bind_templates.exterior_lights_panel()),
    switch_3_0_to_1('Light Flasher Mode', { 'Steady', 'Off', 'Flash' }, nil, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_MODE_SWITCH, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_MODE_SWITCH_INC_DEC, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_MODE_SWITCH_NEXT, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_MODE_SWITCH_AXIS, bind_templates.exterior_lights_panel()),
    switch_3_0_to_1('Tail-Position Lights', { 'Dim', 'Off', 'Bright' }, nil, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_TAIL_SWITCH, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_TAIL_SWITCH_INC_DEC, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_TAIL_SWITCH_NEXT, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_TAIL_SWITCH_AXIS, bind_templates.exterior_lights_panel()),
    switch_3_0_to_1('Wing-Position & Join-Up Lights', { 'Dim', 'Off', 'Bright' }, nil, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_WING_SWITCH, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_WING_SWITCH_INC_DEC, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_WING_SWITCH_NEXT, device_commands.PILOT_EXTERIOR_LIGHTS_PANEL_WING_SWITCH_AXIS, bind_templates.exterior_lights_panel()),

    --*************** VOR/ILS Panel *********************************************************************
    push_button('VOR/ILS Test Button', device_commands.PILOT_ILS_PANEL_TEST_MARKER_BUTTON, device_commands.PILOT_ILS_PANEL_TEST_MARKER_BUTTON_AXIS, bind_templates.vor_ils_panel()),

    knob_inc_dec('VOR/ILS Volume (increment to turn on)', nil, 0.01, device_commands.PILOT_ILS_PANEL_NAV_VOLUME_KNOB_INC_DEC, device_commands.PILOT_ILS_PANEL_NAV_VOLUME_KNOB_AXIS, bind_templates.vor_ils_panel()),
    knob_full_circle('VOR/ILS Frequency (hundreds)', { '108', '109', '110', '111', '112', '113', '114', '115', '116', '117' }, { '[Down]', '[Up]' }, device_commands.PILOT_ILS_PANEL_FREQ_HUNDREDS_KNOB, device_commands.PILOT_ILS_PANEL_FREQ_HUNDREDS_KNOB_INC_DEC, device_commands.PILOT_ILS_PANEL_FREQ_HUNDREDS_KNOB_AXIS, bind_templates.vor_ils_panel()),
    knob_full_circle('VOR/ILS Frequency (decimals)', { '00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60', '65', '70', '75', '80', '85', '90', '95' }, { '[Down]', '[Up]' }, device_commands.PILOT_ILS_PANEL_FREQ_DECIMALS_KNOB, device_commands.PILOT_ILS_PANEL_FREQ_DECIMALS_KNOB_INC_DEC, device_commands.PILOT_ILS_PANEL_FREQ_DECIMALS_KNOB_AXIS, bind_templates.vor_ils_panel()),
    knob_inc_dec('Marker-Beacon Volume', nil, 0.01, device_commands.PILOT_ILS_PANEL_MB_VOLUME_KNOB_INC_DEC, device_commands.PILOT_ILS_PANEL_MB_VOLUME_KNOB_AXIS, bind_templates.vor_ils_panel()),

    --*************** Instrument Light Panel *********************************************************************
    knob_inc_dec('AoA Indicator Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_AAI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_AAI_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),
    knob_inc_dec('HSI Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_HSI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_HSI_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),
    knob_inc_dec('VVI Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_VVI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_VVI_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),
    knob_inc_dec('Speed Indicator Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_MASI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_MASI_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),
    knob_inc_dec('ADI Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_ADI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_ADI_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),
    knob_inc_dec('Altimeter Brightness', nil, 0.01, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_ALT_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_INSTRUMENT_LIGHT_PANEL_ALT_BRIGHTNESS_KNOB_AXIS, bind_templates.instrument_light_panel()),

    --*************** Cockpit Lights Panel *********************************************************************
    switch_2('White Floodlight', nil, device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH, device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_TOGGLE, device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, bind_templates.cockpit_lights_panel()),
    switch_3_0_to_1('Console Floodlight (Red)', { 'Medium', 'Dim', 'Bright' }, nil, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_INC_DEC, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_NEXT, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, bind_templates.cockpit_lights_panel()),

    knob_inc_dec('Instrument Panel Light Brightness', nil, 0.01, device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, bind_templates.cockpit_lights_panel()),
    knob_inc_dec('Console Light Brightness', nil, 0.01, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, bind_templates.cockpit_lights_panel()),

    switch_3_springloaded_down('Lights Test', { 'Warning Lights', 'Off', 'Standby Compass Light' }, nil, device_commands.PILOT_WARNING_LIGHTS_TEST, device_commands.PILOT_WARNING_LIGHTS_TEST_STEP, device_commands.PILOT_WARNING_LIGHTS_TEST_NEXT, device_commands.PILOT_WARNING_LIGHTS_TEST_AXIS, bind_templates.lights_panel()),

    --*************** AVTR Box *********************************************************************
    push_button('Unthread AVTR Cassette', device_commands.PILOT_AVTR_UNTHREAD_BUTTON, device_commands.PILOT_AVTR_UNTHREAD_BUTTON_AXIS, bind_templates.avtr_box()),
    push_button('Eject AVTR Cassette', device_commands.PILOT_AVTR_EJECT_BUTTON, device_commands.PILOT_AVTR_EJECT_BUTTON_AXIS, bind_templates.avtr_box()),
    push_button('Close AVTR Door (Door open only)', device_commands.PILOT_AVTR_CLOSE_DOOR_BUTTON, device_commands.PILOT_AVTR_CLOSE_DOOR_BUTTON_AXIS, bind_templates.avtr_box()),
    push_button('Change AVTR Tape (Cassette out only)', device_commands.PILOT_AVTR_SWAP_CASSETTE_BUTTON, device_commands.PILOT_AVTR_SWAP_CASSETTE_BUTTON_AXIS, bind_templates.avtr_box()),

    --*************** LABS *********************************************************************
    push_button('LABS Pull-Up Lamp Test Button', device_commands.PILOT_PULL_UP_LIGHT_PRESS, device_commands.PILOT_PULL_UP_LIGHT_PRESS_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.labs, categories.main_panel } }),
    knob_inc_dec('LABS Pull-Up Lamp Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_PULL_UP_LIGHT_ROTATION_INC_DEC, device_commands.PILOT_PULL_UP_LIGHT_ROTATION_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.labs, categories.main_panel } }),

    --*********** Helmet *********************************************************************
    switch_2('Helmet Visor', { 'Down', 'Up' }, device_commands.PILOT_HELMET_VISOR_SWITCH, device_commands.PILOT_HELMET_VISOR_TOGGLE, device_commands.PILOT_HELMET_VISOR_AXIS, bind_templates.helmet()),
    switch_2('Sunglasses', nil, device_commands.PILOT_SUNGLASSES_SWITCH, device_commands.PILOT_SUNGLASSES_TOGGLE, device_commands.PILOT_SUNGLASSES_AXIS, bind_templates.helmet()),
    switch_2('Helmet', { 'Take Off', 'Put On' }, device_commands.HIDE_HELMET_PILOT, device_commands.HIDE_HELMET_PILOT_TOGGLE, device_commands.HIDE_HELMET_PILOT_AXIS, bind_templates.helmet()),

    switch_2('Night Vision Goggles (NVG)', nil, device_commands.NVG_SWITCH, device_commands.NVG_TOGGLE, nil, bind_templates.helmet(), { binds = { toggle = { combos = combo('H', 'RShift') } } }),
    bind_templates.helmet({ name = _('Night Vision Goggles (NVG) - Gain Up'), pressed = iCommandPlane_Helmet_Brightess_Up, combos = { { key = 'H', reformers = { 'RCtrl', 'RShift' } } } }),
    bind_templates.helmet({ name = _('Night Vision Goggles (NVG) - Gain Down'), pressed = iCommandPlane_Helmet_Brightess_Down, combos = { { key = 'H', reformers = { 'RAlt', 'RShift' } } } }),

    --*********** Character *********************************************************************
    switch_2('Selfie Mode', { 'Exit', 'Enter' }, device_commands.SELFIE_MODE_SWITCH, device_commands.SELFIE_MODE_TOGGLE, device_commands.SELFIE_MODE_AXIS, { cockpit_device_id = devices.COCKPITMECHANICS, category = categories.general }),
    switch_2('Selfie Body Movement', { 'Unfreeze', 'Freeze' }, device_commands.SELFIE_FREEZE_SWITCH, device_commands.SELFIE_FREEZE_TOGGLE, device_commands.SELFIE_FREEZE_AXIS, { cockpit_device_id = devices.COCKPITMECHANICS, category = categories.general }),

    switch_2('First Person Pilot Body', { 'Hide', 'Show' }, device_commands.VR_BODY_SWITCH, device_commands.VR_BODY_TOGGLE, device_commands.VR_BODY_AXIS, { cockpit_device_id = devices.COCKPITMECHANICS, category = categories.general }, { binds = { toggle = { combos = combo('P', 'LShift') } } }),

    --*********** Manual *********************************************************************
    push_button('Explain (hold and click on something)', device_commands.PILOT_EXPLAIN_BUTTON, nil, bind_templates.manual(), { binds = { push = { combos = combo('M') } } }),
    switch_2('Manual', { 'Close', 'Open' }, device_commands.PILOT_MANUAL_SWITCH, device_commands.PILOT_MANUAL_TOGGLE, nil, bind_templates.manual(), { binds = {
        toggle = { combos = combo('M', 'RAlt') },
        pos_0 = { combos = combo('M', 'RCtrl') },
        pos_1 = { combos = combo('M', 'RShift') },
        pos_2_way = { remove = true },
        pos_2_way_reversed = { remove = true },
    } }),

    --*********** Jester *********************************************************************
    push_button('Jester UI Back', device_commands.PILOT_JESTER_OPTION_BACK, device_commands.PILOT_JESTER_OPTION_BACK_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('1', 'LShift') } } }),
    push_button('Jester UI Navigate To Main Menu', device_commands.PILOT_JESTER_OPTION_NAV_HOME, device_commands.PILOT_JESTER_OPTION_NAV_HOME_AXIS, bind_templates.jester_wheel()),
    push_button('Jester UI Option 1', device_commands.PILOT_JESTER_OPTION_1, device_commands.PILOT_JESTER_OPTION_1_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('1', 'LCtrl') } } }),
    push_button('Jester UI Option 2', device_commands.PILOT_JESTER_OPTION_2, device_commands.PILOT_JESTER_OPTION_2_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('2', 'LCtrl') } } }),
    push_button('Jester UI Option 3', device_commands.PILOT_JESTER_OPTION_3, device_commands.PILOT_JESTER_OPTION_3_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('3', 'LCtrl') } } }),
    push_button('Jester UI Option 4', device_commands.PILOT_JESTER_OPTION_4, device_commands.PILOT_JESTER_OPTION_4_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('4', 'LCtrl') } } }),
    push_button('Jester UI Option 5', device_commands.PILOT_JESTER_OPTION_5, device_commands.PILOT_JESTER_OPTION_5_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('5', 'LCtrl') } } }),
    push_button('Jester UI Option 6', device_commands.PILOT_JESTER_OPTION_6, device_commands.PILOT_JESTER_OPTION_6_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('6', 'LCtrl') } } }),
    push_button('Jester UI Option 7', device_commands.PILOT_JESTER_OPTION_7, device_commands.PILOT_JESTER_OPTION_7_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('7', 'LCtrl') } } }),
    push_button('Jester UI Option 8', device_commands.PILOT_JESTER_OPTION_8, device_commands.PILOT_JESTER_OPTION_8_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('8', 'LCtrl') } } }),

    push_button('Jester UI Left/CCW', device_commands.PILOT_JESTER_OPTION_LEFT, device_commands.PILOT_JESTER_OPTION_LEFT_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('Q') } } }),
    push_button('Jester UI Middle/Select', device_commands.PILOT_JESTER_OPTION_CENTER, device_commands.PILOT_JESTER_OPTION_CENTER_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('W') } } }),
    push_button('Jester UI Right/CW', device_commands.PILOT_JESTER_OPTION_RIGHT, device_commands.PILOT_JESTER_OPTION_RIGHT_AXIS, bind_templates.jester_wheel(), { binds = { push = { combos = combo('E') } } }),

    push_button('Jester UI Hat Up', device_commands.PILOT_JESTER_OPTION_HAT_UP, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Up-Right', device_commands.PILOT_JESTER_OPTION_HAT_UP_RIGHT, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Right', device_commands.PILOT_JESTER_OPTION_HAT_RIGHT, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Down-Right', device_commands.PILOT_JESTER_OPTION_HAT_DOWN_RIGHT, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Down', device_commands.PILOT_JESTER_OPTION_HAT_DOWN, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Down-Left', device_commands.PILOT_JESTER_OPTION_HAT_DOWN_LEFT, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Left', device_commands.PILOT_JESTER_OPTION_HAT_LEFT, nil, bind_templates.jester_wheel()),
    push_button('Jester UI Hat Up-Left', device_commands.PILOT_JESTER_OPTION_HAT_UP_LEFT, nil, bind_templates.jester_wheel()),

    push_button('Jester UI Action (short, hold)', device_commands.PILOT_JESTER_UI_ACTION, device_commands.PILOT_JESTER_UI_ACTION_AXIS, bind_templates.jester_wheel(), { category = { categories.browser, categories.jester, categories.essentials }, binds = { push = { combos = combo('A') } } }),
    push_button('Jester Context Action (short, hold, double click)', device_commands.PILOT_JESTER_CONTEXT_ACTION, device_commands.PILOT_JESTER_CONTEXT_ACTION_AXIS, bind_templates.jester_commands(), { category = { categories.browser, categories.jester, categories.essentials }, binds = { push = { combos = combo('V') } } }),
    push_button('Jester Context Action SHORT (button, direct bind)', device_commands.PILOT_JESTER_CONTEXT_ACTION_SHORT, nil, bind_templates.jester_wheel()),
    push_button('Jester Context Action HOLD (button, direct bind)', device_commands.PILOT_JESTER_CONTEXT_ACTION_LONG, nil, bind_templates.jester_wheel()),
    push_button('Jester Context Action DOUBLE (button, direct bind)', device_commands.PILOT_JESTER_CONTEXT_ACTION_DOUBLE, nil, bind_templates.jester_wheel()),

    --*************** Main Panel *********************************************************************
    push_button('Reset Accelerometer', device_commands.Accelerometer_Pilot_Reset, device_commands.Accelerometer_Pilot_Reset_AXIS, { cockpit_device_id = devices.ACCELEROMETER, category = { categories.instruments, categories.center_panel } }),
    push_button('Fire System Test', device_commands.PILOT_MAIN_PANEL_FIRE_TEST_BUTTON, device_commands.PILOT_MAIN_PANEL_FIRE_TEST_BUTTON_AXIS, { cockpit_device_id = devices.ENGINECONTROLS, category = { categories.engines, categories.center_panel } }),
    -- TODO Add Airspeed-Indicator Bug Knob, but frontend is complex
    -- TODO Add Radar-Altimeter Bug Knob, but frontend is complex
    -- TODO Add Standby-ADI Cage/Trim Knob, but frontend is complex

    --*************** Left Wall *********************************************************************
    switch_2('Ground Safety Override', { 'Safe', 'Armed' }, device_commands.WEAPONS_Armament_Safety_Override, device_commands.WEAPONS_Armament_Safety_Override_Toggle, device_commands.WEAPONS_Armament_Safety_Override_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.weapons, categories.left_wall } }),
    circuit_breaker('Standby Attitude Indicator CB', nil, device_commands.PILOT_LEFT_WALL_SAI_CIRCUIT_BREAKER, device_commands.PILOT_LEFT_WALL_SAI_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_LEFT_WALL_SAI_CIRCUIT_BREAKER_AXIS, { cockpit_device_id = devices.CIRCUIT_BREAKERS, category = { categories.circuit_breakers, categories.left_wall } }),
    knob_inc_dec('Standby Attitude Indicator Brightness', nil, 0.01, device_commands.PILOT_LEFT_WALL_SAI_BRIGHTNESS_KNOB_INC_DEC, device_commands.PILOT_LEFT_WALL_SAI_BRIGHTNESS_KNOB_AXIS, { cockpit_device_id = devices.INTERIOR_LIGHTS, category = { categories.lights, categories.left_wall } }),

    --*************** Left Console *********************************************************************
    switch_2('Gyro Mode', { 'Normal', 'Fast Erect' }, device_commands.PILOT_GYRO_FAST_ERECT_SWITCH, device_commands.PILOT_GYRO_FAST_ERECT_SWITCH_TOGGLE, device_commands.PILOT_GYRO_FAST_ERECT_SWITCH_AXIS, { cockpit_device_id = devices.COMPASSSYSTEM, category = { categories.navigation, categories.left_console } }),
    knob_inc_dec('Aural Tone Volume', nil, 0.01, device_commands.PILOT_AURAL_TONE_VOLUME_KNOB_INC_DEC, device_commands.PILOT_AURAL_TONE_VOLUME_KNOB_AXIS, { category = { categories.weapons, categories.left_console }, cockpit_device_id = devices.AOASYSTEM }),

    --*************** Left Sub-Panel *********************************************************************
    switch_3_0_to_1('Taxi/Landing Light', { 'Taxi Light', 'Off', 'Landing Light' }, { '[Up]', '[Down]' }, device_commands.LANDING_TAXI_LIGHTS_SWITCH, device_commands.LANDING_TAXI_LIGHTS_SWITCH_INC_DEC, device_commands.LANDING_TAXI_LIGHTS_SWITCH_NEXT, device_commands.LANDING_TAXI_LIGHTS_SWITCH_AXIS, { cockpit_device_id = devices.EXTERIOR_LIGHTS, category = { categories.lights, categories.left_sub_panel } }),
    push_button('External Stores Emergency Release', device_commands.PILOT_EXT_STORES_EMERG_RELEASE_BUTTON, device_commands.PILOT_EXT_STORES_EMERG_RELEASE_BUTTON_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.weapons, categories.left_sub_panel } }),
    circuit_breaker('Aileron-Rudder Interconnect (ARI) CB', nil, device_commands.ARI_CIRCUIT_BREAKER, device_commands.ARI_CIRCUIT_BREAKER_TOGGLE, device_commands.ARI_CIRCUIT_BREAKER_AXIS, { cockpit_device_id = devices.CIRCUIT_BREAKERS, category = { categories.circuit_breakers, categories.left_sub_panel } }),

    push_button('AVTR Recorder Lamp Test Button', device_commands.PILOT_RECORDER_LIGHT_PRESS, device_commands.PILOT_RECORDER_LIGHT_PRESS_AXIS, { cockpit_device_id = devices.AIRBORNE_VIDEO_TAPE_RECORDER, category = { categories.cameras, categories.left_sub_panel } }),
    knob_inc_dec('AVTR Recorder Lamp Brightness', { '[Inc]', '[Dec]' }, 0.01, device_commands.PILOT_RECORDER_LIGHT_ROTATION_INC_DEC, device_commands.PILOT_RECORDER_LIGHT_ROTATION_AXIS, { cockpit_device_id = devices.AIRBORNE_VIDEO_TAPE_RECORDER, category = { categories.cameras, categories.left_sub_panel } }),

    --*************** Right Sub-Panel *********************************************************************
    switch_2_springloaded_up('Engine-Feed Tank Test', { 'Normal', 'Check' }, device_commands.PILOT_FUELSYS_FEED_TANK_CHECK_SWITCH, device_commands.PILOT_FUELSYS_FEED_TANK_CHECK_SWITCH_TOGGLE, device_commands.PILOT_FUELSYS_FEED_TANK_CHECK_SWITCH_AXIS, { cockpit_device_id = devices.FuelControls, category = { categories.engines, categories.right_sub_panel } }),

    circuit_breaker('Instrument/Console Lights CB', nil, device_commands.PILOT_RIGHT_SUB_PANEL_PRIM_INST_LT_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_SUB_PANEL_PRIM_INST_LT_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_SUB_PANEL_PRIM_INST_LT_CIRCUIT_BREAKER_AXIS, { cockpit_device_id = devices.CIRCUIT_BREAKERS, category = { categories.circuit_breakers, categories.right_sub_panel } }),
    circuit_breaker('Warning/Indicator Lights CB', nil, device_commands.PILOT_RIGHT_SUB_PANEL_MODE_LT_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_SUB_PANEL_MODE_LT_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_SUB_PANEL_MODE_LT_CIRCUIT_BREAKER_AXIS, { cockpit_device_id = devices.CIRCUIT_BREAKERS, category = { categories.circuit_breakers, categories.right_sub_panel } }),


    --*************** Right Console *********************************************************************
    push_button('Master Caution Reset', device_commands.COCKPIT_MECHANICS_MASTER_CAUTION_Reset, device_commands.COCKPIT_MECHANICS_MASTER_CAUTION_Reset_AXIS, { cockpit_device_id = devices.INDICATORSANDLIGHTS, category = { categories.instruments, categories.right_console } }, { binds = { push = { combos = combo('M', 'LAlt') } } }),
    switch_2('Emergency Release Cockpit Pressure', { 'Seal', 'Release' }, device_commands.PILOT_EMERGENCY_PRESSURE_PLUG, device_commands.PILOT_EMERGENCY_PRESSURE_PLUG_TOGGLE, nil, { category = { categories.oxygen, categories.right_console }, cockpit_device_id = devices.OXYGENSYSTEM }),
    switch_2('Pitot Heat', nil, device_commands.Pitot_Heat_Switch, device_commands.Pitot_Heat_Switch_Toggle, device_commands.Pitot_Heat_Switch_AXIS, { category = { categories.instruments, categories.right_console }, cockpit_device_id = devices.PITOTSTATIC }),

    --*************** Right Wall *********************************************************************
    circuit_breaker('AIL Feel-Trim CB', nil, device_commands.PILOT_RIGHT_WALL_AIL_FEEL_TRIM_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_AIL_FEEL_TRIM_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_AIL_FEEL_TRIM_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),
    circuit_breaker('STAB Feel-Trim CB', nil, device_commands.PILOT_RIGHT_WALL_FEEL_TRIM_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_FEEL_TRIM_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_FEEL_TRIM_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),
    circuit_breaker('Speed Brake CB', nil, device_commands.PILOT_RIGHT_WALL_SPEED_BRAKE_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_SPEED_BRAKE_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_SPEED_BRAKE_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),
    circuit_breaker('Landing Gear CB', nil, device_commands.PILOT_RIGHT_WALL_LANDING_GEAR_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_LANDING_GEAR_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_LANDING_GEAR_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),

    circuit_breaker('Flaps CB', nil, device_commands.PILOT_RIGHT_WALL_FLAPS_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_FLAPS_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_FLAPS_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),
    circuit_breaker('Trim Controls CB', nil, device_commands.PILOT_RIGHT_WALL_TRIM_CONT_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_TRIM_CONT_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_TRIM_CONT_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),
    circuit_breaker('Rudder Trim CB', nil, device_commands.PILOT_RIGHT_WALL_RUD_TRIM_CIRCUIT_BREAKER, device_commands.PILOT_RIGHT_WALL_RUD_TRIM_CIRCUIT_BREAKER_TOGGLE, device_commands.PILOT_RIGHT_WALL_RUD_TRIM_CIRCUIT_BREAKER_AXIS, bind_templates.pilot_cb_panel()),

    knob_inc_dec('AoA Stall Warning Volume', nil, 0.01, device_commands.PILOT_RIGHT_WALL_STALL_VOLUME_KNOB_INC_DEC, device_commands.PILOT_RIGHT_WALL_STALL_VOLUME_KNOB_AXIS, bind_templates.aural_tone_system_pilot()),
    switch_3_0_to_1('Instrument Floodlight (Red) (also WSO)', { 'Dim', 'Off', 'Bright' }, nil, device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH, device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_INC_DEC, device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_NEXT, device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, { cockpit_device_id = devices.INTERIOR_LIGHTS, category = { categories.lights, categories.right_wall } }),

    --*************** Center Console *********************************************************************
    switch_2('Gun Rate', { 'High', 'Low' }, device_commands.WEAPONS_Gun_Rate, device_commands.WEAPONS_Gun_Rate_TOGGLE, device_commands.WEAPONS_Gun_Rate_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.weapons, categories.center_panel } }),
    knob_inc_dec('Gun Rounds Counter Set', nil, 0.12, device_commands.WEAPONS_Round_Counter_Rounds, nil, { cockpit_device_id = devices.WEAPONS, category = { categories.weapons, categories.center_panel } }),
    knob_inc_dec('Pedal Adjust Crank', { '[Aft]', '[Forward]' }, 0.02, device_commands.PILOT_CENTER_PANEL_PEDAL_CRANK, nil, { cockpit_device_id = devices.CONTROLSURFACES, category = { categories.pedals, categories.center_panel } }),
    switch_3_0_to_1_springloaded_down('TGT / MSL Switch', { 'Missile Reject', 'Norm', 'Direction Finding Reject' }, { '[Up]', '[Down]' }, device_commands.TGT_MSL_SWITCH, device_commands.TGT_MSL_SWITCH_INC_DEC, device_commands.TGT_MSL_SWITCH_NEXT, device_commands.TGT_MSL_SWITCH_AXIS, { cockpit_device_id = devices.WEAPONS, category = { categories.weapons, categories.center_panel } }),

    --*************** Misc *********************************************************************
    switch_2('Grease Pencil', { 'Close', 'Open' }, device_commands.PILOT_GREASE_PENCIL_SWITCH, device_commands.PILOT_GREASE_PENCIL_TOGGLE, device_commands.PILOT_GREASE_PENCIL_AXIS, bind_templates.grease_pencil()),
    switch_2('Bombing Table', { 'Close', 'Open' }, device_commands.PILOT_BOMBING_TABLE_SWITCH, device_commands.PILOT_BOMBING_TABLE_TOGGLE, nil, bind_templates.bombing_table(), { binds = {
        toggle = { combos = combo('B', 'RCtrl') },
        pos_2_way = { remove = true },
        pos_2_way_reversed = { remove = true },
    } }),
    switch_2('Virtual Browser', { 'Close', 'Open' }, device_commands.PILOT_VIRTUAL_BROWSER_SWITCH, device_commands.PILOT_VIRTUAL_BROWSER_TOGGLE, nil, bind_templates.virtual_browser(), { binds = {
        toggle = { combos = combo('V', 'RCtrl') },
        pos_2_way = { remove = true },
        pos_2_way_reversed = { remove = true },
    } }),
    switch_2('Jester Console', { 'Close', 'Open' }, device_commands.PILOT_JESTER_CONSOLE_SWITCH, device_commands.PILOT_JESTER_CONSOLE_TOGGLE, nil, bind_templates.jester_console(), { binds = {
        toggle = { combos = combo('L', 'RCtrl') },
        pos_2_way = { remove = true },
        pos_2_way_reversed = { remove = true },
    } }),
    push_button('Tanker: Intent To Refuel', device_commands.TANKER_INTENT_TO_REFUEL, nil, bind_templates.ics_panel()),
    push_button('Tanker: Pre-Contact', device_commands.TANKER_PRE_CONTACT, nil, bind_templates.ics_panel()),

    switch_3_springloaded_both('Seat Position', { 'Up', 'Stop', 'Down' }, { '[Aft]', '[Forward]' }, device_commands.PILOT_SEAT_POS_SWITCH, device_commands.PILOT_SEAT_POS_SWITCH_INC_DEC, device_commands.PILOT_SEAT_POS_SWITCH_AXIS, { cockpit_device_id = devices.SEAT, category = { categories.seat } }),

    push_button('Auto Start', device_commands.PILOT_AUTO_START, nil, bind_templates.cheat(), { binds = { push = { combos = combo('Home', 'LWin') } } }),
    push_button('Auto Stop', device_commands.PILOT_AUTO_STOP, nil, bind_templates.cheat(), { binds = { push = { combos = combo('End', 'LWin') } } }),

    --*********** Jester Direct Wheel Commands *********************************************************************
    push_button('Jester Command: UHF Radio > Mode > Off', device_commands.JESTER_COMMAND_RADIO_MODE_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Mode > T/R, ADF', device_commands.JESTER_COMMAND_RADIO_MODE_TRADF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Mode > T/R+G, ADF', device_commands.JESTER_COMMAND_RADIO_MODE_TRGADF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Mode > ADF+G, CMD', device_commands.JESTER_COMMAND_RADIO_MODE_ADFGCMD, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Mode > ADF, G', device_commands.JESTER_COMMAND_RADIO_MODE_ADFG, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Mode > G, ADF', device_commands.JESTER_COMMAND_RADIO_MODE_GADF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Frequency Mode > Preset', device_commands.JESTER_COMMAND_RADIO_FREQ_MODE_PRESET, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Frequency Mode > Manual', device_commands.JESTER_COMMAND_RADIO_FREQ_MODE_MANUAL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 1', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_1, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 2', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_2, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 3', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_3, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 4', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_4, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 5', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_5, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 6', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_6, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 7', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_7, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 8', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_8, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 9', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_9, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 10', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_10, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 11', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_11, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 12', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_12, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 13', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_13, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 14', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_14, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 15', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_15, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 16', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_16, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 17', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_17, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Comm > 18', device_commands.JESTER_COMMAND_RADIO_CHANNEL_COM_18, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 1', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_1, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 2', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_2, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 3', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_3, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 4', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_4, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 5', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_5, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 6', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_6, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 7', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_7, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 8', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_8, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 9', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_9, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 10', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_10, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 11', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_11, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 12', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_12, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 13', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_13, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 14', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_14, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 15', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_15, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 16', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_16, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 17', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_17, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 18', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_18, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 19', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_19, nil, bind_templates.jester_commands()),
    push_button('Jester Command: UHF Radio > Channel > Aux > 20', device_commands.JESTER_COMMAND_RADIO_CHANNEL_AUX_20, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Operation > Active', device_commands.JESTER_COMMAND_RADAR_OPERATION_ACTIVE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Operation > Standby', device_commands.JESTER_COMMAND_RADAR_OPERATION_STANDBY, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Operation > Auto Focus On', device_commands.JESTER_COMMAND_RADAR_AUTO_FOCUS_ON, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Operation > Auto Focus Off', device_commands.JESTER_COMMAND_RADAR_AUTO_FOCUS_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > IFF', device_commands.JESTER_COMMAND_RADAR_IFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > Enter BST', device_commands.JESTER_COMMAND_RADAR_BST_ENTER, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > WIDE Aspect', device_commands.JESTER_COMMAND_RADAR_BST_ASPECT_WIDE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > NOSE Aspect', device_commands.JESTER_COMMAND_RADAR_BST_ASPECT_NOSE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > FORWARD Aspect', device_commands.JESTER_COMMAND_RADAR_BST_ASPECT_FORWARD, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > AFT Aspect', device_commands.JESTER_COMMAND_RADAR_BST_ASPECT_AFT, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Boresight > TAIL Aspect', device_commands.JESTER_COMMAND_RADAR_BST_ASPECT_TAIL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 0 - 10k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_0_10_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 10 - 20k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_10_20_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 20 - 30k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_20_30_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 30 - 40k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_30_40_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 40 - 50k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_40_50_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > 50 - 60k ft', device_commands.JESTER_COMMAND_RADAR_SCAN_50_60_ABS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > Center', device_commands.JESTER_COMMAND_RADAR_SCAN_CENTER_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > -3500 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_MINUS_3_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > -5000 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_MINUS_5_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > -7500 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_MINUS_7_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > +3500 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_PLUS_3_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > +5000 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_PLUS_5_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Elevation > +7500 ft', device_commands.JESTER_COMMAND_RADAR_SCAN_PLUS_7_REL, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Type > 25nm Wide', device_commands.JESTER_COMMAND_RADAR_RANGE_25_WIDE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Type > 25nm Narrow', device_commands.JESTER_COMMAND_RADAR_RANGE_25_NARROW, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Type > 50nm Wide', device_commands.JESTER_COMMAND_RADAR_RANGE_50_WIDE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Radar > Scan Type > 50nm Narrow', device_commands.JESTER_COMMAND_RADAR_RANGE_50_NARROW, nil, bind_templates.jester_commands()),
    push_button('Jester Command: A2G > Video Source > Weapons', device_commands.JESTER_COMMAND_A2G_VIDEO_WEAPONS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: A2G > Video Source > Pave Spike', device_commands.JESTER_COMMAND_A2G_VIDEO_PAVE_SPIKE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: A2G > Pave Spike > Operation > Ready', device_commands.JESTER_COMMAND_A2G_TGP_OPERATION_READY, nil, bind_templates.jester_commands()),
    push_button('Jester Command: A2G > Pave Spike > Operation > Standby', device_commands.JESTER_COMMAND_A2G_TGP_OPERATION_STANDBY, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Navigate With > TGT 1', device_commands.JESTER_COMMAND_NAV_WITH_TGT1, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Navigate With > TGT 2', device_commands.JESTER_COMMAND_NAV_WITH_TGT2, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Tacan > Mode > Off', device_commands.JESTER_COMMAND_NAV_TACAN_MODE_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Tacan > Mode > R', device_commands.JESTER_COMMAND_NAV_TACAN_MODE_R, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Tacan > Mode > T/R', device_commands.JESTER_COMMAND_NAV_TACAN_MODE_TR, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Tacan > Mode > A/A R', device_commands.JESTER_COMMAND_NAV_TACAN_MODE_AAR, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Tacan > Mode > A/A T/R', device_commands.JESTER_COMMAND_NAV_TACAN_MODE_AATR, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Navigation > Fine-Align INS', device_commands.JESTER_COMMAND_NAV_FINE_ALIGN_INS, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Chaff Mode > Off', device_commands.JESTER_COMMAND_SYSTEMS_CHAFF_MODE_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Chaff Mode > Single', device_commands.JESTER_COMMAND_SYSTEMS_CHAFF_MODE_SINGLE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Chaff Mode > Multiple', device_commands.JESTER_COMMAND_SYSTEMS_CHAFF_MODE_MULTIPLE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Chaff Mode > Program', device_commands.JESTER_COMMAND_SYSTEMS_CHAFF_MODE_PROGRAM, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Flare Mode > Off', device_commands.JESTER_COMMAND_SYSTEMS_FLARE_MODE_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Flare Mode > Single', device_commands.JESTER_COMMAND_SYSTEMS_FLARE_MODE_SINGLE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Flare Mode > Program', device_commands.JESTER_COMMAND_SYSTEMS_FLARE_MODE_PROGRAM, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Jammer > Standby', device_commands.JESTER_COMMAND_SYSTEMS_JAMMER_STANDBY, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > Jammer > Transmit', device_commands.JESTER_COMMAND_SYSTEMS_JAMMER_TRANSMIT, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > AVTR > Record', device_commands.JESTER_COMMAND_SYSTEMS_AVTR_RECORD, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > AVTR > Standby', device_commands.JESTER_COMMAND_SYSTEMS_AVTR_STANDBY, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Systems > AVTR > Off', device_commands.JESTER_COMMAND_SYSTEMS_AVTR_OFF, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Talking > Talk', device_commands.JESTER_COMMAND_CREW_TALKING_TALK, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Talking > Silence', device_commands.JESTER_COMMAND_CREW_TALKING_SILENCE, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Ejection > WSO', device_commands.JESTER_COMMAND_CREW_EJECTION_WSO, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Ejection > Both', device_commands.JESTER_COMMAND_CREW_EJECTION_BOTH, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Presence > Auto', device_commands.JESTER_COMMAND_CREW_PRESENCE_AUTO, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Presence > Force', device_commands.JESTER_COMMAND_CREW_PRESENCE_ENABLED, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Presence > Disable', device_commands.JESTER_COMMAND_CREW_PRESENCE_DISABLED, nil, bind_templates.jester_commands()),
    push_button('Jester Command: Crew Contract > Start Alignment', device_commands.JESTER_COMMAND_CREW_START_ALIGNMENT, nil, bind_templates.jester_commands()),

    --*********** Crew Chief Direct Wheel Commands *********************************************************************
    push_button('Crew Chief Command: Comms Check', device_commands.CREW_CHIEF_COMMAND_COMMS_CHECK, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Wheel Chocks > Place', device_commands.CREW_CHIEF_COMMAND_WHEEL_CHOCKS_PLACE, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Wheel Chocks > Remove', device_commands.CREW_CHIEF_COMMAND_WHEEL_CHOCKS_REMOVE, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: External Power > Connect', device_commands.CREW_CHIEF_COMMAND_EXT_POWER_CONNECT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: External Power > Disconnect', device_commands.CREW_CHIEF_COMMAND_EXT_POWER_DISCONNECT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Connect Right Engine', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_CONNECT_RIGHT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Connect Left Engine', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_CONNECT_LEFT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Start Flow', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_START, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Stop Flow', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_STOP, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Disconnect', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_DISCONNECT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Load Starter Cartridges', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_LOAD_CARTRIDGES, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Air Source > Remove Starter Cartridges', device_commands.CREW_CHIEF_COMMAND_AIR_SOURCE_REMOVE_CARTRIDGES, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Boarding > Place Ladder', device_commands.CREW_CHIEF_COMMAND_BOARDING_LADDER_PLACE, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Boarding > Remove Ladder', device_commands.CREW_CHIEF_COMMAND_BOARDING_LADDER_REMOVE, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Boarding > Extend Steps', device_commands.CREW_CHIEF_COMMAND_BOARDING_STEPS_EXTEND, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Boarding > Retract Steps', device_commands.CREW_CHIEF_COMMAND_BOARDING_STEPS_RETRACT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > Pitot Heat', device_commands.CREW_CHIEF_COMMAND_CHECKS_PITOT_HEAT, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > Spoiler Actuator', device_commands.CREW_CHIEF_COMMAND_CHECKS_SPOILER_ACTUATOR, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > Flight Controls', device_commands.CREW_CHIEF_COMMAND_CHECKS_FLIGHT_CONTROLS, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > ARI Disengage', device_commands.CREW_CHIEF_COMMAND_CHECKS_ARI_DISENGAGE, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > Stab Aug', device_commands.CREW_CHIEF_COMMAND_CHECKS_STAB_AUG, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Checks > Trim Neutral', device_commands.CREW_CHIEF_COMMAND_CHECKS_TRIM_NEUTRAL, nil, bind_templates.crew_chief_commands()),
    push_button('Crew Chief Command: Cancel', device_commands.CREW_CHIEF_COMMAND_CANCEL, nil, bind_templates.crew_chief_commands()),
}

join_override(res.keyCommands, unpack_nested_binds(binds, function(bind_name) return bind_name ~= 'axis' end))
join_override(res.axisCommands, unpack_nested_binds(binds, function(bind_name) return bind_name == 'axis' end))

return res
